/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CommonTokenStream;
import org.python.antlr.BaseParser;
import org.python.antlr.ExpressionParser;
import org.python.antlr.InteractiveParser;
import org.python.antlr.ModuleParser;
import org.python.antlr.NoCloseReaderStream;
import org.python.antlr.ParseException;
import org.python.antlr.PythonPartial;
import org.python.antlr.PythonTokenSource;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.modType;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIndentationError;
import org.python.core.PySyntaxError;
import org.python.core.io.BufferedReader;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOInputStream;
import org.python.core.io.UniversalIOWrapper;
import org.python.core.util.StringUtil;

public class ParserFacade {
    private static int MARK_LIMIT = 100000;

    private ParserFacade() {
    }

    static String getLine(java.io.BufferedReader reader, int line) {
        if (reader == null) {
            return "";
        }
        String text = null;
        try {
            for (int i = 0; i < line; ++i) {
                text = reader.readLine();
            }
            return text;
        }
        catch (IOException iOException) {
            return text;
        }
    }

    public static PyException fixParseError(java.io.BufferedReader reader, Throwable t, String filename) {
        if (reader != null) {
            try {
                reader.reset();
            }
            catch (IOException e) {
                reader = null;
            }
        }
        if (t instanceof ParseException) {
            ParseException e = (ParseException)t;
            PythonTree node = (PythonTree)e.node;
            int line = e.line;
            int col = e.charPositionInLine;
            if (node != null) {
                line = node.getLine();
                col = node.getCharPositionInLine();
            }
            String text = ParserFacade.getLine(reader, line);
            String msg = e.getMessage();
            if (e.getType() == Py.IndentationError) {
                return new PyIndentationError(msg, line, col, text, filename);
            }
            return new PySyntaxError(msg, line, col, text, filename);
        }
        return Py.JavaError(t);
    }

    public static modType parse(InputStream stream, String kind, String filename, CompilerFlags cflags) {
        modType node;
        block13: {
            java.io.BufferedReader bufreader = null;
            node = null;
            try {
                if (kind.equals("eval")) {
                    bufreader = ParserFacade.prepBufreader(stream, cflags, filename);
                    NoCloseReaderStream cs = new NoCloseReaderStream(bufreader);
                    ExpressionParser e = new ExpressionParser(cs, filename);
                    node = e.parse();
                    break block13;
                }
                if (kind.equals("single")) {
                    bufreader = ParserFacade.prepBufreader(stream, cflags, filename);
                    InteractiveParser i = new InteractiveParser(bufreader, filename);
                    node = i.parse();
                    break block13;
                }
                if (kind.equals("exec")) {
                    bufreader = ParserFacade.prepBufreader(stream, cflags, filename);
                    NoCloseReaderStream cs = new NoCloseReaderStream(bufreader);
                    ModuleParser g = new ModuleParser(cs, filename);
                    node = g.file_input();
                    break block13;
                }
                throw Py.ValueError("parse kind must be eval, exec, or single");
            }
            catch (Throwable t) {
                throw ParserFacade.fixParseError(bufreader, t, filename);
            }
            finally {
                try {
                    if (bufreader != null) {
                        bufreader.close();
                    }
                }
                catch (IOException i) {}
            }
        }
        return node;
    }

    public static modType partialParse(String string, String kind, String filename, CompilerFlags cflags, boolean stdprompt) {
        modType node;
        block5: {
            ByteArrayInputStream istream = new ByteArrayInputStream(StringUtil.toBytes(string));
            java.io.BufferedReader bufreader = null;
            node = null;
            try {
                if (kind.equals("single")) {
                    bufreader = ParserFacade.prepBufreader(istream, cflags, filename);
                    InteractiveParser i = new InteractiveParser(bufreader, filename);
                    node = i.parse();
                    break block5;
                }
                if (kind.equals("eval")) {
                    bufreader = ParserFacade.prepBufreader(istream, cflags, filename);
                    NoCloseReaderStream cs = new NoCloseReaderStream(bufreader);
                    ExpressionParser e = new ExpressionParser(cs, filename);
                    node = e.parse();
                    break block5;
                }
                throw Py.ValueError("parse kind must be eval, exec, or single");
            }
            catch (Throwable t) {
                PyException p = ParserFacade.fixParseError(bufreader, t, filename);
                if (ParserFacade.validPartialSentence(bufreader, kind, filename)) {
                    return null;
                }
                throw p;
            }
        }
        return node;
    }

    private static boolean validPartialSentence(java.io.BufferedReader bufreader, String kind, String filename) {
        block4: {
            BaseParser.PyLexer lexer = null;
            try {
                bufreader.reset();
                NoCloseReaderStream cs = new NoCloseReaderStream(bufreader);
                lexer = new BaseParser.PyLexer(cs);
                lexer.partial = true;
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                PythonTokenSource indentedSource = new PythonTokenSource(tokens, filename);
                tokens = new CommonTokenStream(indentedSource);
                PythonPartial parser = new PythonPartial(tokens);
                if (kind.equals("single")) {
                    parser.single_input();
                    break block4;
                }
                if (kind.equals("eval")) {
                    parser.eval_input();
                    break block4;
                }
                return false;
            }
            catch (Exception e) {
                return lexer.eofWhileNested;
            }
        }
        return true;
    }

    private static java.io.BufferedReader prepBufreader(InputStream istream, CompilerFlags cflags, String filename) throws IOException {
        InputStreamReader reader;
        boolean bom = false;
        String encoding = null;
        InputStream bstream = new BufferedInputStream(istream);
        bom = ParserFacade.adjustForBOM(bstream);
        encoding = ParserFacade.readEncoding(bstream);
        if (encoding == null) {
            if (bom) {
                encoding = "UTF-8";
            } else if (cflags != null && cflags.encoding != null) {
                encoding = cflags.encoding;
            }
        } else if (cflags.source_is_utf8) {
            throw new ParseException("encoding declaration in Unicode string");
        }
        StreamIO rawIO = new StreamIO(bstream, true);
        BufferedReader bufferedIO = new BufferedReader(rawIO, 0);
        UniversalIOWrapper textIO = new UniversalIOWrapper(bufferedIO);
        bstream = new TextIOInputStream(textIO);
        if (encoding != null) {
            try {
                reader = new InputStreamReader(bstream, encoding);
            }
            catch (UnsupportedEncodingException exc) {
                throw new PySyntaxError("Encoding '" + encoding + "' isn't supported by this JVM.", 0, 0, "", filename);
            }
        }
        try {
            reader = new InputStreamReader(bstream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw Py.SystemError("Java couldn't find the ISO-8859-1 encoding");
        }
        java.io.BufferedReader bufreader = new java.io.BufferedReader(reader);
        bufreader.mark(MARK_LIMIT);
        return bufreader;
    }

    private static boolean adjustForBOM(InputStream stream) throws IOException {
        stream.mark(3);
        int ch = stream.read();
        if (ch == 239) {
            if (stream.read() != 187) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            if (stream.read() != 191) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            return true;
        }
        stream.reset();
        return false;
    }

    private static String readEncoding(InputStream stream) throws IOException {
        String strLine;
        stream.mark(MARK_LIMIT);
        String encoding = null;
        java.io.BufferedReader br = new java.io.BufferedReader(new InputStreamReader(stream), 512);
        for (int i = 0; i < 2 && (strLine = br.readLine()) != null; ++i) {
            String result = ParserFacade.matchEncoding(strLine);
            if (result == null) continue;
            encoding = result;
            break;
        }
        stream.reset();
        return ParserFacade.encodingMap(encoding);
    }

    private static String encodingMap(String encoding) {
        if (encoding == null) {
            return null;
        }
        if (encoding.equals("Latin-1") || encoding.equals("latin-1")) {
            return "ISO8859_1";
        }
        return encoding;
    }

    private static String matchEncoding(String inputStr) {
        String patternStr = "coding[:=]\\s*([-\\w.]+)";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        boolean matchFound = matcher.find();
        if (matchFound && matcher.groupCount() == 1) {
            String groupStr = matcher.group(1);
            return groupStr;
        }
        return null;
    }
}

