/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import org.python.antlr.ast.modType;
import org.python.compiler.Module;
import org.python.core.APIReader;
import org.python.core.BytecodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.JavaImportHelper;
import org.python.core.Options;
import org.python.core.ParserFacade;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.SyspathArchive;
import org.python.core.SyspathJavaLoader;
import org.python.core.__builtin__;
import org.python.core.util.FileUtil;

public class imp {
    private static final String IMPORT_LOG = "import";
    private static final String UNKNOWN_SOURCEFILE = "<unknown>";
    public static final int APIVersion = 16;
    public static final int DEFAULT_LEVEL = -1;
    private static final PyObject nonEmptyFromlist = new PyTuple(Py.newString("__doc__"));
    public static final ReentrantLock importLock = new ReentrantLock();
    private static Object syspathJavaLoaderLock = new Object();
    private static ClassLoader syspathJavaLoader = null;
    private static PyTuple all = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSyspathJavaLoader() {
        Object object = syspathJavaLoaderLock;
        synchronized (object) {
            if (syspathJavaLoader == null) {
                syspathJavaLoader = new SyspathJavaLoader();
            }
        }
        return syspathJavaLoader;
    }

    private imp() {
    }

    public static PyModule addModule(String name) {
        PyObject modules = Py.getSystemState().modules;
        PyModule module = (PyModule)modules.__finditem__(name = name.intern());
        if (module != null) {
            return module;
        }
        module = new PyModule(name, null);
        modules.__setitem__(name, (PyObject)module);
        return module;
    }

    private static byte[] readBytes(InputStream fp) {
        try {
            byte[] byArray = FileUtil.readBytes(fp);
            return byArray;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        finally {
            try {
                fp.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
    }

    private static InputStream makeStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    static PyObject createFromPyClass(String name, InputStream fp, boolean testing, String fileName) {
        PyCode code;
        byte[] data = imp.readCode(name, fp, testing);
        if (testing && data == null) {
            return null;
        }
        try {
            code = BytecodeLoader.makeCode(name + "$py", data, fileName);
        }
        catch (Throwable t) {
            if (testing) {
                return null;
            }
            throw Py.JavaError(t);
        }
        Py.writeComment(IMPORT_LOG, "'" + name + "' as " + fileName);
        return imp.createFromCode(name, code, fileName);
    }

    public static byte[] readCode(String name, InputStream fp, boolean testing) {
        int api;
        byte[] data = imp.readBytes(fp);
        int n = data.length;
        try {
            APIReader ar = new APIReader(data);
            api = ar.getVersion();
        }
        catch (IOException i) {
            api = -1;
        }
        if (api != 16) {
            if (testing) {
                return null;
            }
            throw Py.ImportError("invalid api version(" + api + " != " + 16 + ") in: " + name);
        }
        return data;
    }

    public static byte[] compileSource(String name, File file, String sourceFilename, String compiledFilename) {
        if (sourceFilename == null) {
            sourceFilename = file.toString();
        }
        return imp.compileSource(name, imp.makeStream(file), sourceFilename);
    }

    public static String makeCompiledFilename(String filename) {
        return filename.substring(0, filename.length() - 3) + "$py.class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cacheCompiledSource(String sourceFilename, String compiledFilename, byte[] compiledSource) {
        if (compiledFilename == null) {
            if (sourceFilename == null || sourceFilename.equals(UNKNOWN_SOURCEFILE)) {
                return null;
            }
            compiledFilename = imp.makeCompiledFilename(sourceFilename);
        }
        FileOutputStream fop = null;
        try {
            fop = new FileOutputStream(compiledFilename);
            fop.write(compiledSource);
            fop.close();
            String string = compiledFilename;
            return string;
        }
        catch (IOException exc) {
            Py.writeDebug(IMPORT_LOG, "Unable to write to source cache file '" + compiledFilename + "' due to " + exc);
            String string = null;
            return string;
        }
        finally {
            if (fop != null) {
                try {
                    fop.close();
                }
                catch (IOException e) {
                    Py.writeDebug(IMPORT_LOG, "Unable to close source cache file '" + compiledFilename + "' due to " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compileSource(String name, InputStream fp, String filename) {
        ByteArrayOutputStream ofp = new ByteArrayOutputStream();
        try {
            modType node;
            if (filename == null) {
                filename = UNKNOWN_SOURCEFILE;
            }
            try {
                node = ParserFacade.parse(fp, "exec", filename, new CompilerFlags());
            }
            finally {
                fp.close();
            }
            Module.compile(node, ofp, name + "$py", filename, true, false, true, null);
            return ofp.toByteArray();
        }
        catch (Throwable t) {
            throw ParserFacade.fixParseError(null, t, filename);
        }
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename) {
        return imp.createFromSource(name, fp, filename, null);
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename, String outFilename) {
        byte[] bytes = imp.compileSource(name, fp, filename);
        outFilename = imp.cacheCompiledSource(filename, outFilename, bytes);
        Py.writeComment(IMPORT_LOG, "'" + name + "' as " + filename);
        PyCode code = BytecodeLoader.makeCode(name + "$py", bytes, filename);
        return imp.createFromCode(name, code, filename);
    }

    public static PyObject createFromCode(String name, PyCode c) {
        return imp.createFromCode(name, c, null);
    }

    public static PyObject createFromCode(String name, PyCode c, String moduleLocation) {
        PyModule module = imp.addModule(name);
        PyTableCode code = null;
        if (c instanceof PyTableCode) {
            code = (PyTableCode)c;
        }
        try {
            PyFrame f = new PyFrame(code, module.__dict__, module.__dict__, null);
            code.call(f);
        }
        catch (RuntimeException t) {
            Py.getSystemState().modules.__delitem__(name.intern());
            throw t;
        }
        if (moduleLocation != null) {
            module.__setattr__("__file__", (PyObject)new PyString(moduleLocation));
        } else {
            Py.writeDebug(IMPORT_LOG, "No fileName known to set __file__ for " + name + ".");
        }
        return module;
    }

    static PyObject createFromClass(String name, Class c) {
        if (PyRunnable.class.isAssignableFrom(c)) {
            try {
                return imp.createFromCode(name, ((PyRunnable)c.newInstance()).getMain());
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
        }
        return PyJavaClass.lookup(c);
    }

    static PyObject getPathImporter(PyObject cache, PyList hooks, PyObject p) {
        PyObject hook;
        PyObject importer = cache.__finditem__(p);
        if (importer != null) {
            return importer;
        }
        PyObject iter = hooks.__iter__();
        while ((hook = iter.__iternext__()) != null) {
            try {
                importer = hook.__call__(p);
                break;
            }
            catch (PyException e) {
                if (Py.matchException(e, Py.ImportError)) continue;
                throw e;
            }
        }
        importer = importer == null ? Py.None : importer;
        cache.__setitem__(p, importer);
        return importer;
    }

    static PyObject replacePathItem(PySystemState sys, PyObject path) {
        if (path instanceof SyspathArchive) {
            return null;
        }
        try {
            return new SyspathArchive(sys.getPath(path.toString()));
        }
        catch (Exception e) {
            return null;
        }
    }

    static PyObject find_module(String name, String moduleName, PyList path) {
        PyObject loader = Py.None;
        PySystemState sys = Py.getSystemState();
        PyList metaPath = sys.meta_path;
        PyList ppath = path == null ? sys.path : path;
        for (int i = 0; i < ppath.__len__(); ++i) {
            PyObject p = ppath.__getitem__(i);
            PyObject q = imp.replacePathItem(sys, p);
            if (q == null) continue;
            ppath.__setitem__(i, q);
        }
        for (PyObject importer : metaPath.asIterable()) {
            PyObject findModule = importer.__getattr__("find_module");
            PyObject[] pyObjectArray = new PyObject[2];
            pyObjectArray[0] = new PyString(moduleName);
            PyObject pyObject = pyObjectArray[1] = path == null ? Py.None : path;
            loader = findModule.__call__(pyObjectArray);
            if (loader == Py.None) continue;
            return imp.loadFromLoader(loader, moduleName);
        }
        PyObject ret = imp.loadBuiltin(moduleName);
        if (ret != null) {
            return ret;
        }
        path = path == null ? sys.path : path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject findModule;
            PyObject p = path.__getitem__(i);
            PyObject importer = imp.getPathImporter(sys.path_importer_cache, sys.path_hooks, p);
            if (importer != Py.None && (loader = (findModule = importer.__getattr__("find_module")).__call__(new PyObject[]{new PyString(moduleName)})) != Py.None) {
                return imp.loadFromLoader(loader, moduleName);
            }
            ret = imp.loadFromSource(sys, name, moduleName, p.__str__().toString());
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private static PyObject loadBuiltin(String name) {
        Class c;
        if (name == "sys") {
            Py.writeComment(IMPORT_LOG, "'" + name + "' as sys in " + "builtin modules");
            return Py.java2py(Py.getSystemState());
        }
        String mod = PySystemState.getBuiltin(name);
        if (mod != null && (c = Py.findClassEx(mod, "builtin modules")) != null) {
            Py.writeComment(IMPORT_LOG, "'" + name + "' as " + mod + " in builtin modules");
            try {
                if (PyObject.class.isAssignableFrom(c)) {
                    return PyType.fromClass(c);
                }
                return imp.createFromClass(name, c);
            }
            catch (NoClassDefFoundError e) {
                throw Py.ImportError("Cannot import " + name + ", missing class " + c.getName());
            }
        }
        return null;
    }

    static PyObject loadFromLoader(PyObject importer, String name) {
        PyObject load_module = importer.__getattr__("load_module");
        return load_module.__call__(new PyObject[]{new PyString(name)});
    }

    public static PyObject loadFromCompiled(String name, InputStream stream, String filename) {
        return imp.createFromPyClass(name, stream, false, filename);
    }

    static PyObject loadFromSource(PySystemState sys, String name, String modName, String entry) {
        String filename;
        boolean pkg;
        String sourceName = "__init__.py";
        String compiledName = "__init__$py.class";
        String directoryName = sys.getPath(entry);
        String displayDirName = entry.equals("") ? null : entry.toString();
        File dir = new File(directoryName, name);
        File sourceFile = new File(dir, sourceName);
        File compiledFile = new File(dir, compiledName);
        boolean bl = pkg = dir.isDirectory() && imp.caseok(dir, name) && (sourceFile.isFile() || compiledFile.isFile());
        if (!pkg) {
            Py.writeDebug(IMPORT_LOG, "trying source " + dir.getPath());
            sourceName = name + ".py";
            compiledName = name + "$py.class";
            sourceFile = new File(directoryName, sourceName);
            compiledFile = new File(directoryName, compiledName);
        } else {
            PyModule m = imp.addModule(modName);
            PyString filename2 = new PyString(new File(displayDirName, name).getPath());
            m.__dict__.__setitem__("__path__", (PyObject)new PyList(new PyObject[]{filename2}));
            m.__dict__.__setitem__("__file__", (PyObject)filename2);
        }
        if (sourceFile.isFile() && imp.caseok(sourceFile, sourceName)) {
            filename = pkg ? new File(new File(displayDirName, name), sourceName).getPath() : new File(displayDirName, sourceName).getPath();
            if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName)) {
                PyObject ret;
                Py.writeDebug(IMPORT_LOG, "trying precompiled " + compiledFile.getPath());
                long pyTime = sourceFile.lastModified();
                long classTime = compiledFile.lastModified();
                if (classTime >= pyTime && (ret = imp.createFromPyClass(modName, imp.makeStream(compiledFile), true, filename)) != null) {
                    return ret;
                }
            }
            return imp.createFromSource(modName, imp.makeStream(sourceFile), filename, compiledFile.getPath());
        }
        Py.writeDebug(IMPORT_LOG, "trying precompiled with no source " + compiledFile.getPath());
        if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName)) {
            filename = new File(displayDirName, compiledName).getPath();
            return imp.createFromPyClass(modName, imp.makeStream(compiledFile), true, filename);
        }
        return null;
    }

    public static boolean caseok(File file, String filename) {
        if (Options.caseok) {
            return true;
        }
        try {
            File canFile = new File(file.getCanonicalPath());
            return filename.regionMatches(0, canFile.getName(), 0, filename.length());
        }
        catch (IOException exc) {
            return false;
        }
    }

    public static PyObject load(String name) {
        return imp.import_first(name, new StringBuffer());
    }

    private static String getParent(PyObject dict, int level) {
        if (dict == null || level == 0) {
            return null;
        }
        PyObject tmp = dict.__finditem__("__name__");
        if (tmp == null) {
            return null;
        }
        String name = tmp.toString();
        tmp = dict.__finditem__("__path__");
        if (tmp != null && tmp instanceof PyList) {
            return name.intern();
        }
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            if (level > 0) {
                throw Py.ValueError("Attempted relative import in non-package");
            }
            return null;
        }
        name = name.substring(0, dot);
        while (--level > 0) {
            dot = name.lastIndexOf(46);
            if (dot == -1) {
                throw Py.ValueError("Attempted relative import beyond toplevel package");
            }
            name = name.substring(0, dot);
        }
        return name.intern();
    }

    private static PyObject import_next(PyObject mod, StringBuffer parentNameBuffer, String name, String outerFullName, PyObject fromlist) {
        if (parentNameBuffer.length() > 0) {
            parentNameBuffer.append('.');
        }
        parentNameBuffer.append(name);
        String fullName = parentNameBuffer.toString().intern();
        PyObject modules = Py.getSystemState().modules;
        PyObject ret = modules.__finditem__(fullName);
        if (ret != null) {
            return ret;
        }
        ret = mod == null ? imp.find_module(fullName.intern(), name, null) : mod.impAttr(name.intern());
        if (ret == null || ret == Py.None) {
            if (JavaImportHelper.tryAddPackage(outerFullName, fromlist)) {
                ret = modules.__finditem__(fullName);
            }
            return ret;
        }
        if (modules.__finditem__(fullName) == null) {
            modules.__setitem__(fullName, ret);
        } else {
            ret = modules.__finditem__(fullName);
        }
        return ret;
    }

    private static PyObject import_first(String name, StringBuffer parentNameBuffer) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name, null, null);
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("No module named " + name);
        }
        return ret;
    }

    private static PyObject import_first(String name, StringBuffer parentNameBuffer, String fullName, PyObject fromlist) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name, fullName, fromlist);
        if ((ret == null || ret == Py.None) && JavaImportHelper.tryAddPackage(fullName, fromlist)) {
            ret = imp.import_next(null, parentNameBuffer, name, fullName, fromlist);
        }
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("No module named " + name);
        }
        return ret;
    }

    private static PyObject import_logic(PyObject mod, StringBuffer parentNameBuffer, String dottedName, String fullName, PyObject fromlist) {
        int dot = 0;
        int last_dot = 0;
        do {
            String name;
            if ((mod = imp.import_next(mod, parentNameBuffer, name = (dot = dottedName.indexOf(46, last_dot)) == -1 ? dottedName.substring(last_dot) : dottedName.substring(last_dot, dot), fullName, fromlist)) == null || mod == Py.None) {
                throw Py.ImportError("No module named " + name);
            }
            last_dot = dot + 1;
        } while (dot != -1);
        return mod;
    }

    private static PyObject import_name(String name, boolean top, PyObject modDict, PyObject fromlist, int level) {
        int dot;
        String firstName;
        StringBuffer parentNameBuffer;
        PyObject topMod;
        if (name.length() == 0) {
            throw Py.ValueError("Empty module name");
        }
        PyObject modules = Py.getSystemState().modules;
        PyObject pkgMod = null;
        String pkgName = null;
        if (modDict != null && !(modDict instanceof PyNone) && (pkgMod = modules.__finditem__(pkgName = imp.getParent(modDict, level))) != null && !(pkgMod instanceof PyModule)) {
            pkgMod = null;
        }
        if ((topMod = imp.import_next(pkgMod, parentNameBuffer = new StringBuffer(pkgMod != null ? pkgName : ""), firstName = (dot = name.indexOf(46)) == -1 ? name : name.substring(0, dot), name, fromlist)) == Py.None || topMod == null) {
            if (topMod == null && pkgMod != null) {
                modules.__setitem__(parentNameBuffer.toString().intern(), Py.None);
            }
            parentNameBuffer = new StringBuffer("");
            topMod = imp.import_first(firstName, parentNameBuffer, name, fromlist);
        }
        PyObject mod = topMod;
        if (dot != -1) {
            mod = imp.import_logic(topMod, parentNameBuffer, name.substring(dot + 1), name, fromlist);
        }
        if (top) {
            return topMod;
        }
        if (fromlist != null && fromlist != Py.None) {
            StringBuffer modNameBuffer = new StringBuffer(name);
            for (PyObject submodName : fromlist.asIterable()) {
                if (mod.__findattr__(submodName.toString()) != null || submodName.toString().equals("*")) continue;
                String fullName = modNameBuffer.toString() + "." + submodName.toString();
                imp.import_next(mod, modNameBuffer, submodName.toString(), fullName, null);
            }
        }
        return mod;
    }

    public static PyObject importName(String name, boolean top) {
        return imp.import_name(name, top, null, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyObject importName(String name, boolean top, PyObject modDict, PyObject fromlist, int level) {
        importLock.lock();
        try {
            PyObject pyObject = imp.import_name(name, top, modDict, fromlist, level);
            return pyObject;
        }
        finally {
            importLock.unlock();
        }
    }

    public static PyObject importOne(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getLocals(), Py.EmptyTuple);
        return module;
    }

    public static PyObject importOneAs(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getLocals(), imp.getStarArg());
        return module;
    }

    public static PyObject[] importFrom(String mod, String[] names, PyFrame frame) {
        return imp.importFromAs(mod, names, null, frame, -1);
    }

    public static PyObject[] importFrom(String mod, String[] names, PyFrame frame, int level) {
        return imp.importFromAs(mod, names, null, frame, level);
    }

    public static PyObject[] importFromAs(String mod, String[] names, PyFrame frame) {
        return imp.importFromAs(mod, names, null, frame, -1);
    }

    public static PyObject[] importFromAs(String mod, String[] names, String[] asnames, PyFrame frame, int level) {
        PyObject[] pyNames = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            pyNames[i] = Py.newString(names[i]);
        }
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getLocals(), new PyTuple(pyNames), level);
        PyObject[] submods = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            PyObject submod = module.__findattr__(names[i]);
            if (submod == null) {
                throw Py.ImportError("cannot import name " + names[i]);
            }
            submods[i] = submod;
        }
        return submods;
    }

    private static synchronized PyTuple getStarArg() {
        if (all == null) {
            all = new PyTuple(Py.newString('*'));
        }
        return all;
    }

    public static void importAll(String mod, PyFrame frame) {
        PyObject names;
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getLocals(), imp.getStarArg());
        boolean filter = true;
        if (module instanceof PyJavaPackage) {
            names = ((PyJavaPackage)module).fillDir();
        } else {
            PyObject __all__ = module.__findattr__("__all__");
            if (__all__ != null) {
                names = __all__;
                filter = false;
            } else {
                names = module.__dir__();
            }
        }
        imp.loadNames(names, module, frame.getLocals(), filter);
    }

    private static void loadNames(PyObject names, PyObject module, PyObject locals, boolean filter) {
        for (PyObject name : names.asIterable()) {
            String sname = ((PyString)name).internedString();
            if (filter && sname.startsWith("_")) continue;
            try {
                PyObject nameObj;
                PyObject value = module.__findattr__(sname);
                if (value == null && (nameObj = module.__findattr__("__name__")) != null) {
                    String submodName = nameObj.__str__().toString() + '.' + sname;
                    value = __builtin__.__import__(submodName, null, null, nonEmptyFromlist);
                }
                locals.__setitem__(sname, value);
            }
            catch (Exception exc) {}
        }
    }

    static PyObject reload(PyJavaClass c) {
        return c;
    }

    static PyObject reload(PyModule m) {
        PyObject modules = Py.getSystemState().modules;
        String name = m.__getattr__("__name__").toString().intern();
        PyModule nm = (PyModule)modules.__finditem__(name);
        if (nm == null || !nm.__getattr__("__name__").toString().equals(name)) {
            throw Py.ImportError("reload(): module " + name + " not in sys.modules");
        }
        PyList path = Py.getSystemState().path;
        String modName = name;
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            String iname = name.substring(0, dot).intern();
            PyObject pkg = modules.__finditem__(iname);
            if (pkg == null) {
                throw Py.ImportError("reload(): parent not in sys.modules");
            }
            path = (PyList)pkg.__getattr__("__path__");
            name = name.substring(dot + 1, name.length()).intern();
        }
        nm.__setattr__("__name__", (PyObject)new PyString(modName));
        PyObject ret = imp.find_module(name, modName, path);
        modules.__setitem__(modName, ret);
        return ret;
    }
}

