/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Diff
extends SvnCommand {
    private SVNUrl oldUrl = null;
    private SVNUrl newUrl = null;
    private File oldPath = null;
    private File newPath = null;
    private SVNRevision oldTargetRevision = null;
    private SVNRevision newTargetRevision = null;
    private File outFile = new File("patch");
    private boolean recurse = true;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.validateAttributes();
        this.log("Svn : diff");
        try {
            if (this.oldUrl != null) {
                iSVNClientAdapter.diff(this.oldUrl, this.oldTargetRevision, this.newUrl, this.newTargetRevision, this.outFile, this.recurse);
            } else {
                iSVNClientAdapter.diff(this.oldPath, this.oldTargetRevision, this.newPath, this.newTargetRevision, this.outFile, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't get the differences", (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.oldUrl != null ? this.oldPath != null || this.newPath != null : this.oldUrl != null || this.newUrl != null) {
            throw new BuildException("paths cannot be with urls when diffing");
        }
    }

    public void setNewPath(File file) {
        this.newPath = file;
    }

    public void setNewTargetRevision(String string) {
        try {
            this.newTargetRevision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            this.newTargetRevision = null;
        }
    }

    public void setNewUrl(SVNUrl sVNUrl) {
        this.newUrl = sVNUrl;
    }

    public void setOldPath(File file) {
        this.oldPath = file;
    }

    public void setOldTargetRevision(String string) {
        try {
            this.oldTargetRevision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            this.oldTargetRevision = null;
        }
    }

    public void setOldUrl(SVNUrl sVNUrl) {
        this.oldUrl = sVNUrl;
    }

    public void setOutFile(File file) {
        this.outFile = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

