/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.ExcludeProcessor;
import com.tonicsystems.jarjar.Keep;
import com.tonicsystems.jarjar.KeepProcessor;
import com.tonicsystems.jarjar.ManifestProcessor;
import com.tonicsystems.jarjar.PackageRemapper;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.ResourceProcessor;
import com.tonicsystems.jarjar.Rule;
import com.tonicsystems.jarjar.Zap;
import com.tonicsystems.jarjar.ZapProcessor;
import com.tonicsystems.jarjar.ext_util.ClassTransformer;
import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import com.tonicsystems.jarjar.ext_util.JarProcessorChain;
import com.tonicsystems.jarjar.ext_util.JarTransformerChain;
import com.tonicsystems.jarjar.ext_util.RemappingClassTransformer;
import com.tonicsystems.jarjar.ext_util.StandaloneJarProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MainProcessor
implements JarProcessor {
    private final boolean verbose;
    private final JarProcessor chain;
    private final KeepProcessor kp;
    private final Map renames = new HashMap();

    public MainProcessor(List patterns, boolean verbose, boolean skipManifest) {
        this.verbose = verbose;
        ArrayList<PatternElement> zapList = new ArrayList<PatternElement>();
        ArrayList<PatternElement> ruleList = new ArrayList<PatternElement>();
        ArrayList<PatternElement> keepList = new ArrayList<PatternElement>();
        for (PatternElement pattern : patterns) {
            if (pattern instanceof Zap) {
                zapList.add(pattern);
                continue;
            }
            if (pattern instanceof Rule) {
                ruleList.add(pattern);
                continue;
            }
            if (!(pattern instanceof Keep)) continue;
            keepList.add(pattern);
        }
        PackageRemapper pr = new PackageRemapper(ruleList, verbose);
        this.kp = keepList.isEmpty() ? null : new KeepProcessor(keepList);
        ArrayList<JarProcessor> processors = new ArrayList<JarProcessor>();
        if (skipManifest) {
            processors.add(ManifestProcessor.getInstance());
        }
        if (this.kp != null) {
            processors.add(this.kp);
        }
        processors.add(new ZapProcessor(zapList));
        processors.add(new JarTransformerChain(new ClassTransformer[]{new RemappingClassTransformer(pr)}));
        processors.add(new ResourceProcessor(pr));
        this.chain = new JarProcessorChain(processors.toArray(new JarProcessor[processors.size()]));
    }

    public void strip(File file) throws IOException {
        if (this.kp == null) {
            return;
        }
        Set excludes = this.getExcludes();
        if (!excludes.isEmpty()) {
            StandaloneJarProcessor.run(file, file, new ExcludeProcessor(excludes, this.verbose));
        }
    }

    private Set getExcludes() {
        Set excludes = this.kp.getExcludes();
        HashSet<String> result = new HashSet<String>();
        Iterator it = excludes.iterator();
        while (it.hasNext()) {
            String name = it.next() + ".class";
            String renamed = (String)this.renames.get(name);
            result.add(renamed != null ? renamed : name);
        }
        return result;
    }

    public boolean process(EntryStruct struct) throws IOException {
        String name = struct.name;
        boolean result = this.chain.process(struct);
        if (result) {
            if (!name.equals(struct.name)) {
                if (this.kp != null) {
                    this.renames.put(name, struct.name);
                }
                if (this.verbose) {
                    System.err.println("Renamed " + name + " -> " + struct.name);
                }
            }
        } else if (this.verbose) {
            System.err.println("Removed " + name);
        }
        return result;
    }
}

