% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{matvec-methods}
\alias{matvec}
\alias{matvec,Tensor-method}
\alias{matvec-methods}
\title{Tensor Matvec Unfolding}
\usage{
matvec(tnsr)

\S4method{matvec}{Tensor}(tnsr)
}
\arguments{
\item{tnsr}{the Tensor instance}
}
\value{
matrix with \code{prod(x@modes[-m])} rows and \code{x@modes[m]} columns
}
\description{
For 3-tensors only. Stacks the slices along the third mode. This is the prevalent unfolding for T-SVD and T-MULT based on block circulant matrices.
}
\details{
\code{matvec(tnsr)}
}
\examples{
tnsr <- rand_tensor(c(2,3,4))
matT1<- matvec(tnsr)
}
\references{
M. Kilmer, K. Braman, N. Hao, and R. Hoover, "Third-order tensors as operators on matrices: a theoretical and computational framework with applications in imaging". SIAM Journal on Matrix Analysis and Applications 2013.
}
\seealso{
\code{\link{k_unfold-methods}} and \code{\link{unfold-methods}}
}

