% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{any.torch.Tensor}
\alias{any.torch.Tensor}
\title{any}
\usage{
\method{any}{torch.Tensor}(x, dim, ...)
}
\arguments{
\item{x}{tensor}

\item{dim}{dimension to reduce}

\item{...}{other params (yet to be developed)}
}
\value{
A tensor of type torch.uint8 representing the boolean result:
1 for TRUE and 0 for FALSE.
}
\description{
Returns True if any elements in the tensor are non-zero, False otherwise.
}
\examples{
\dontrun{
a <- torch$BoolTensor(list(TRUE, TRUE, TRUE, TRUE))
b <- torch$BoolTensor(list(FALSE, TRUE, TRUE, TRUE))
c <- torch$BoolTensor(list(TRUE, TRUE, TRUE, FALSE))
any(a)
any(b)
any(c)
d <- torch$tensor(list(list(1, 0),
                       list(0, 0),
                       list(0, 1),
                       list(0, 0)), dtype=torch$uint8)
any(d)
any(d, dim=0L)
any(d, dim=1L)
}
}
