% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{nonReliableVGenes}
\alias{nonReliableVGenes}
\title{Detect non reliable gene assignment}
\usage{
nonReliableVGenes(clip_db, thresh = 0.9, appearance = 0.01)
}
\arguments{
\item{clip_db}{a \code{data.frame} in Change-O format. See details.}

\item{thresh}{the threshold to consider non reliable gene. Defualt is 0.9}

\item{appearance}{the minimun fraction of gene appearance to be considered for reliability check. Defualt is 0.01.}
}
\value{
a nested list of non reliable genes for all subject.
}
\description{
\code{nonReliableVGenes} Takes a \code{data.frame} in Change-O format  and detect non reliable IGHV genes. A non reliable gene is
when the ratio of the multiple assignments with a gene is below the threshold.
}
\details{
The function accepts a \code{data.frame} in Change-O format (\url{https://changeo.readthedocs.io/en/version-0.4.1---airr-standards/standard.html}) containing the following columns:
\itemize{
  \item \code{'SUBJECT'}: subject names
  \item \code{'V_CALL'}: V allele call(s) (in an IMGT format)
}
}
\examples{
# Example IGHV call data frame
clip_db <- data.frame(SUBJECT=rep('S1',6),
V_CALL=c('IGHV1-69*01','IGHV1-69*01','IGHV1-69*01,IGHV1-69*02',
'IGHV4-59*01,IGHV4-61*01','IGHV4-59*01,IGHV4-31*02','IGHV4-59*01'))
# Detect non reliable genes
nonReliableVGenes(clip_db)
}
