% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{plotHaplotype}
\alias{plotHaplotype}
\title{Graphical output of an inferred haplotype}
\usage{
plotHaplotype(
  hap_table,
  html_output = FALSE,
  gene_sort = c("name", "position"),
  text_size = 14,
  removeIGH = TRUE,
  plotYaxis = TRUE,
  chain = c("IGH", "IGK", "IGL"),
  dir
)
}
\arguments{
\item{hap_table}{haplotype summary table. See details.}

\item{html_output}{if TRUE, a html5 interactive graph is outputed. Defualt is FALSE.}

\item{gene_sort}{if by 'name' the genes in the output are ordered lexicographically,
if by 'position' only functional genes are used and are ordered by their chromosomal location. Default is 'position'.}

\item{text_size}{the size of graph labels. Default is 14 (pts).}

\item{removeIGH}{if TRUE, 'IGH'\'IGK'\'IGL' prefix is removed from gene names.}

\item{plotYaxis}{if TRUE, Y axis labels (gene names) are plotted on the middle and right plots. Default is TRUE.}

\item{chain}{the Ig chain: IGH,IGK,IGL. Default is IGH.}

\item{dir}{The output folder for saving the haplotype map for multiple individuals.}
}
\value{
A haplotype map visualization. If more than one subject is visualized, a pdf is created. If html_output is TRUE, a folder named html_output is created with individual graphs.
}
\description{
The \code{plotHaplotype} functions visualizes an inferred haplotype.
}
\details{
A \code{data.frame} in a haplotype format created by \code{createFullHaplotype} function.
}
\examples{

# Selecting a single individual from the haplotype samples data
haplo_db = samplesHaplotype[samplesHaplotype$SUBJECT=='I5', ]

# plot haplotype
plotHaplotype(haplo_db)

}
