% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{deletionHeatmap}
\alias{deletionHeatmap}
\title{Graphical output of single chromosome deletions}
\usage{
deletionHeatmap(
  hap_table,
  chain = c("IGH", "IGK", "IGL", "TRB", "TRA"),
  kThreshDel = 3,
  genes_order = NULL,
  html_output = FALSE
)
}
\arguments{
\item{hap_table}{haplotype summary table. See details.}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH.}

\item{kThreshDel}{the minimum lK (log10 of the Bayes factor) used in \code{createFullHaplotype} to call a deletion. Indicates the color for strong deletion. Default is 3.}

\item{genes_order}{A vector of the genes by the desired order. Default is by GENE.loc}

\item{html_output}{If TRUE, a html5 interactive graph is outputed insteaed of the normal plot. Default is FALSE}
}
\value{
A single chromosome deletion visualization.
}
\description{
The \code{deletionHeatmap} function generates a graphical output of the single chromosome deletions in multiple samples.
}
\details{
A \code{data.frame} created by \code{createFullHaplotype}.
}
\examples{
# Plotting single choromosme deletion from haplotype inference
deletionHeatmap(samplesHaplotype)
}
