% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_prop.R
\name{plot.single_prop}
\alias{plot.single_prop}
\title{Plot method for the single_prop function}
\usage{
\method{plot}{single_prop}(x, plots = "bar", shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{single_prop}}}

\item{plots}{Plots to generate. "bar" shows a bar chart of the data. The "simulate" chart shows the location of the sample proportion and the comparison value (comp_value). Simulation is used to demonstrate the sampling variability in the data under the null-hypothesis}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the single_prop function
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/single_prop.html} for an example in Radiant
}
\examples{
result <- single_prop(titanic, "survived", lev = "Yes", comp_value = 0.5,  alternative = "less")
plot(result, plots = c("bar", "simulate"))

}
\seealso{
\code{\link{single_prop}} to generate the result

\code{\link{summary.single_prop}} to summarize the results
}
