% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Visualize data using ggplot2 \url{http://docs.ggplot2.org/current/}}
\usage{
visualize(dataset, xvar, yvar = "", comby = FALSE, combx = FALSE,
  type = "dist", facet_row = ".", facet_col = ".", color = "none",
  fill = "none", bins = 10, smooth = 1, fun = "mean", check = "",
  axes = "", alpha = 0.5, data_filter = "", shiny = FALSE,
  custom = FALSE)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{xvar}{One or more variables to display along the X-axis of the plot}

\item{yvar}{Variable to display along the Y-axis of the plot (default = "none")}

\item{comby}{Combine yvars in plot (TRUE or FALSE, FALSE is the default)}

\item{combx}{Combine xvars in plot (TRUE or FALSE, FALSE is the default)}

\item{type}{Type of plot to create. One of Distribution ('dist'), Density ('density'), Scatter ('scatter'), Surface ('surface'), Line ('line'), Bar ('bar'), or Box-plot ('box')}

\item{facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{color}{Adds color to a scatter plot to generate a 'heat map'. For a line plot one line is created for each group and each is assigned a different color}

\item{fill}{Display bar, distribution, and density plots by group, each with a different color. Also applied to surface plots to generate a 'heat map'}

\item{bins}{Number of bins used for a histogram (1 - 50)}

\item{smooth}{Adjust the flexibility of the loess line for scatter plots}

\item{fun}{Set the summary measure for line and bar plots when the X-variable is a factor (default is "mean"). Also used to plot an error bar in a scatter plot when the X-variable is a factor. Options are "mean" and/or "median"}

\item{check}{Add a regression line ("line"), a loess line ("loess"), or jitter ("jitter") to a scatter plot}

\item{axes}{Flip the axes in a plot ("flip") or apply a log transformation (base e) to the y-axis ("log_y") or the x-axis ("log_x")}

\item{alpha}{Opacity for plot elements (0 to 1)}

\item{data_filter}{Expression used to filter the dataset. This should be a string (e.g., "price > 10000")}

\item{shiny}{Logical (TRUE, FALSE) to indicate if the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This opion can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org/} for options.}
}
\value{
Generated plots
}
\description{
Visualize data using ggplot2 \url{http://docs.ggplot2.org/current/}
}
\details{
See \url{http://radiant-rstats.github.io/docs/data/visualize.html} for an example in Radiant
}
\examples{
visualize("diamonds", "price:x", type = "dist")
visualize("diamonds", "carat:x", yvar = "price", type = "scatter")
visualize(dataset = "diamonds", yvar = "price", xvar = c("cut","clarity"),
  type = "bar", fun = "median")
visualize(dataset = "diamonds", yvar = "price", xvar = c("cut","clarity"),
  type = "line", fun = "max")
visualize(dataset = "diamonds", yvar = "price", xvar = "carat", type = "scatter", custom = TRUE) +
  ggtitle("A scatterplot") + xlab("price in $")
visualize(dataset = "diamonds", xvar = "price:carat", custom = TRUE) \%>\%
  {.[[1]] + ggtitle("A histogram") + xlab("price in $")}
visualize(dataset = "diamonds", xvar = "cut", yvar = "price", type = "bar",
  facet_row = "cut", fill = "cut", custom = FALSE)

}

