> Manage data and state: Load data into Radiant, Save data to disk, Remove a dataset from memory, or Save/Load the state of the app

### Datasets

When you first start Radiant a dataset (`diamonds`) with information on diamond prices is shown.

It is good practice to add a description of the data and variables to each file you use. For the files that are bundled with Radiant you will see a brief overview of the variables etc. below a table of the first 10 rows of the data. To add a description for your own data click the `Add/edit data description` check-box. A text-input box will open below the table where you can add text in
<a href="http://rmarkdown.rstudio.com/authoring_pandoc_markdown.html" target="_blank">markdown</a> format. The description provided for the `diamonds` data included with Radiant should serve as a good example. After adding or editing a description click the `Update description` button.

To rename a dataset loaded in Radiant click the `Rename data` check box, enter a new name, and click the `Rename` button

### Load data

The best way to load and save data for use in Radiant (and R) is to use the R-data format (rds or rda). These are binary files that can be stored compactly and read into R quickly. Select `rds` (or `rda`) from the `Load data of type` dropdown and click `Browse` to locate the file(s) you want to load on your computer.

You can get data from a spreadsheet (e.g., Excel or Google sheets) into Radiant in two ways. First, you can save data from the spreadsheet in csv format and then, in Radiant, choose `csv` from the `Load data of type` dropdown. Most likely you will have a header row in the csv file with variable names. If the data are not comma separated you can choose semicolon or tab separated. To load a csv file click 'Browse' and locate the file on your computer.

Alternatively, you can select and copy the data in the spreadsheet using CTRL-C (or CMD-C on mac), go to Radiant, choose `clipboard` from the `Load data of type` dropdown, and click the `Paste` button. This is a short-cut that can be convenient for smaller datasets that are cleanly formatted.

If the data is available in R's global workspace (e.g., you opened a data set in Rstudio and then started Radiant from the `addins` menu) you can move (or copy) it to Radiant by selecting `from global workspace`. Select the data.frame(s) you want to use and click the `Load` button.

To access all data files bundled with Radiant choose `examples` from the `Load data of type` dropdown and then click the `Load` button. These files are used to illustrate the various data and analysis tools accessible in Radiant. For example, the `avengers` and `publishers` data are used to illustrate how to combine data in R(adiant) (i.e., _Data > Combine_).

If `csv` data is available online choose `csv (url)` from the dropdown, paste the url into the text input shown, and press `Load`. If an `rda` file is available online choose `rda (url)` from the dropdown, paste the url into the text input, and press `Load`.

### Save data

As mentioned above, the most convenient way to get data in and out of Radiant is to use the R-data format (rds or rda). Choose `rds` (or `rda`) from the `Save data to type` dropdown and click the `Save` button to save the selected dataset to file.

Again, it is good practice to add a description of the data and variables to each file you use. To add a description for your own data click the 'Add/edit data description' check-box, add text to the text-input window shown in
<a href="http://rmarkdown.rstudio.com/authoring_pandoc_markdown.html" target="_blank">markdown</a> format, and then click the `Update description` button. When you save the data as an rds (or rda) file the description you created (or edited) will automatically be added to the file as an `attribute`.

Getting data from Radiant into a spreadsheet can be achieved in two ways. First, you can save data in csv format and load the file into the spreadsheet (i.e., choose `csv` from the `Save data to type` dropdown and click the `Save` button). Alternatively, you can copy the data from Radiant into the clipboard by choosing `clipboard` from the dropdown and clicking the `Copy` button, open the spreadsheet, and paste the data from Radiant using CTRL-V (or CMD-V on mac).

To move or copy data from Radiant into R(studio)'s global workspace select `to global workspace` from the `Save data to type` dropdown and click the `Save` button.

### Save and load state

It is convenient to work with state files if you want complete your work at another time, perhaps on another computer, or to review previous work you completed using Radiant. You can save and load the state of the Radiant app just as you would a data file. The state file (extension `.state.rda`) will contain (1) the data loaded in Radiant, (2) settings for the analyses you were working on, (3) and any reports or code from the _Report_ menu. To save the current state of the app to your hard-disk click the <i title='Save' class='fa fa-save'></i> icon in the navbar and then click `Save radiant state file`. To load load a previous state click the <i title='Save' class='fa fa-save'></i> icon in the navbar and the click `Load radiant state file`. 

You can also share a state file with others that would like to replicate your analyses. As an example, download and then load the state file [radiant-example.state.rda](https://github.com/radiant-rstats/docs/raw/gh-pages/examples/radiant-example.state.rda){target="_blank"} as described above. You will navigate automatically to the _Data > Visualize_ tab and will see a plot. See also the _Data > View_ tab for some additional settings loaded from the state file. There is also a report in _Report > Rmd_ created using the Radiant interface. The html file <a href="https://radiant-rstats.github.io/docs/examples/radiant-example.nb.html" target="_blank">radiant-example.nb.html</a> contains the output created by clicking the `Knit report` button.

Loading and saving state also works with Rstudio. If you start Radiant from Rstudio and use <i title='Power off' class='fa fa-power-off'></i> and then click `Stop`, the `r_data` environment and the `r_info` and `r_state` lists will be put into Rstudio's global workspace. If you start radiant again from the `Addins` menu it will use `r_data`, `r_info`, and `r_state` to restore state. Also, if you load a state file directly into Rstudio it will be used when you start Radiant.

Use `Refresh` in the <i title='Power off' class='fa fa-power-off'></i> menu in the navbar to return to a clean/new state.

### Remove data from memory

If data are loaded in memory that you no longer need in the current session check the `Remove data from memory` box. Then select the data to remove and click the `Remove data` button. One datafile will always remain open.

### Using commands to load and save data

R-code can be used in _Report > Rmd_ or _Report > R_ to load data from a file directly into the active Radiant session. Use `register("insert-dataset-name")` to add a dataset to the `Datasets` dropdown. R-code can also be used to extract data from Radiant and save it to disk. 

### R-functions

For an overview of related R-functions used by Radiant to load and save data see <a href = " https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-manage" target="_blank">_Data > Manage_</a>
