% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{filter_data}
\alias{filter_data}
\title{Filter data with user-specified expression}
\usage{
filter_data(dataset, filt = "", drop = TRUE)
}
\arguments{
\item{dataset}{Data frame to filter}

\item{filt}{Filter expression to apply to the specified dataset}

\item{drop}{Drop unused factor levels after filtering (default is TRUE)}
}
\value{
Filtered data frame
}
\description{
Filter data with user-specified expression
}
\details{
Filters can be used to view a sample from a selected dataset. For example, runif(nrow(.)) > .9 could be used to sample approximately 10% of the rows in the data and 1:nrow(.) < 101 would select only the first 100 rows in the data. Note: "." references the currently selected dataset.
}
\examples{
select(diamonds, 1:3) \%>\% filter_data(filt = "price > max(.$price) - 100")
select(diamonds, 1:3) \%>\% filter_data(filt = "runif(nrow(.)) > .995")
}
