% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{plot.mnl.predict}
\alias{plot.mnl.predict}
\title{Plot method for mnl.predict function}
\usage{
\method{plot}{mnl.predict}(x, xvar = "", facet_row = ".", facet_col = ".", color = ".class", ...)
}
\arguments{
\item{x}{Return value from predict function predict.mnl}

\item{xvar}{Variable to display along the X-axis of the plot}

\item{facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{color}{Adds color to a scatter plot to generate a heat map. For a line plot one line is created for each group and each is assigned a different color}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for mnl.predict function
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
pred <- predict(result, pred_cmd = "price.heinz28 = seq(3, 5, 0.1)")
plot(pred, xvar = "price.heinz28")

}
\seealso{
\code{\link{predict.mnl}} to generate predictions
}
