% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn}
\alias{nn}
\title{Neural Networks using nnet}
\usage{
nn(
  dataset,
  rvar,
  evar,
  type = "classification",
  lev = "",
  size = 1,
  decay = 0.5,
  wts = "None",
  seed = NA,
  check = "standardize",
  form,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{type}{Model type (i.e., "classification" or "regression")}

\item{lev}{The level in the response variable defined as _success_}

\item{size}{Number of units (nodes) in the hidden layer}

\item{decay}{Parameter decay}

\item{wts}{Weights to use in estimation}

\item{seed}{Random seed to use as the starting point}

\item{check}{Optional estimation parameters ("standardize" is the default)}

\item{form}{Optional formula to use instead of rvar and evar}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in nn as an object of class nn
}
\description{
Neural Networks using nnet
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nn.html} for an example in Radiant
}
\examples{
nn(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\% summary()
nn(titanic, "survived", c("pclass", "sex")) \%>\% str()
nn(diamonds, "price", c("carat", "clarity"), type = "regression") \%>\% summary()
}
\seealso{
\code{\link{summary.nn}} to summarize results

\code{\link{plot.nn}} to plot results

\code{\link{predict.nn}} for prediction
}
