% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{mds}
\alias{mds}
\title{(Dis)similarity based brand maps (MDS)}
\usage{
mds(dataset, id1, id2, dis, method = "metric", nr_dim = 2, seed = 1234,
  data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{id1}{A character variable or factor with unique entries}

\item{id2}{A character variable or factor with unique entries}

\item{dis}{A numeric measure of brand dissimilarity}

\item{method}{Apply metric or non-metric MDS}

\item{nr_dim}{Number of dimensions}

\item{seed}{Random seed}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables defined in the function as an object of class mds
}
\description{
(Dis)similarity based brand maps (MDS)
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/mds.html} for an example in Radiant
}
\examples{
result <- mds("city", "from", "to", "distance")
summary(result)
result <- mds("diamonds", "clarity", "cut", "price")
summary(result)

}
\seealso{
\code{\link{summary.mds}} to summarize results

\code{\link{plot.mds}} to plot results
}

