% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sample_size.R
\name{sample_size}
\alias{sample_size}
\title{Sample size calculation}
\usage{
sample_size(ss_type = "mean", ss_mean_err = 2, ss_mean_s = 10,
  ss_prop_err = 0.1, ss_prop_p = 0.5, ss_z = 1.96, ss_incidence = 1,
  ss_response = 1, ss_pop_correction = "no", ss_pop_size = 1000000)
}
\arguments{
\item{ss_type}{Choose "mean" or "proportion"}

\item{ss_mean_err}{Acceptable Error for Mean}

\item{ss_mean_s}{Standard deviation for Mean}

\item{ss_prop_err}{Acceptable Error for Proportion}

\item{ss_prop_p}{Initial proportion estimate for Proportion}

\item{ss_z}{Z-value}

\item{ss_incidence}{Incidence rate (i.e., fraction of valid respondents)}

\item{ss_response}{Response rate}

\item{ss_pop_correction}{Apply correction for population size ("yes","no")}

\item{ss_pop_size}{Population size}
}
\value{
A list of variables defined in sample_size as an object of class sample_size
}
\description{
Sample size calculation
}
\details{
See \url{http://vnijs.github.io/radiant/quant/sample_size.html} for an example in Radiant
}
\examples{
result <- sample_size(ss_type = "mean", ss_mean_err = 2, ss_mean_s = 10)
}
\seealso{
\code{\link{summary.sample_size}} to summarize results
}

