% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_raw_data.R
\name{tfrdpub}
\alias{tfrdpub}
\title{Transfer personal genotype raw data according public dataset}
\usage{
tfrdpub(genotype, K, map, f)
}
\arguments{
\item{genotype}{A data.frame contains your genotype information.}

\item{K}{The number of populations}

\item{map}{A data.frame, it should contain rsid, major allele and minor allele 
information for both plus and minus strands. You should download datasets from
GitHub.}

\item{f}{Frequency matrix learned from reference panel. You should download
datasets from GitHub.}
}
\value{
A list contains g, q, f which can be used for calculation.
}
\description{
Transfer personal genotype raw data to g matrix which the number of row is 1 and
the number of column is the number of SNPs used here.
}
\details{
Please download datasets from \href{https://github.com/wegene-llc/radmixture}{GitHub}
See README.
}
\examples{
## download.file(url = 'https://github.com/wegene-llc/radmixture/
## raw/master/data/globe4.alleles.RData', destfile = 'K4.RData')
## download.file(url = 'https://github.com/wegene-llc/radmixture/
## raw/master/data/globe4.4.F.RData', destfile = 'K4f.RData')
## load('K4.RData')
## load('K4f.RData')
## res <- tfrdpub(genotype, 4, globe4.alleles, globe4.4.F)
}
