% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{fit_variance_cumulation}
\alias{fit_variance_cumulation}
\title{Fit piecewise constant volatilities to a set of equity options}
\usage{
fit_variance_cumulation(S0, eq_options, mid_prices, spreads = NULL,
  initial_vols_guess = 0.55 + 0 * mid_prices, use_impvol = TRUE,
  relative_spread_tolerance = 0.01, force_same_grid = FALSE,
  num_time_steps = 40, const_short_rate = 0,
  const_default_intensity = 0, discount_factor_fcn = function(T, t,
  ...) {     exp(-const_short_rate * (T - t)) },
  survival_probability_fcn = function(T, t, ...) {    
  exp(-const_default_intensity * (T - t)) },
  default_intensity_fcn = function(t, S, ...) {    
  const_default_intensity + 0 * S }, dividends = NULL, borrow_cost = 0,
  dividend_rate = 0, ...)
}
\arguments{
\item{S0}{Current stock price}

\item{eq_options}{A list of options to find prices for.  Each must have fields \code{callput},
\code{maturity}, and \code{strike}.  This list must be in strictly increasing order of maturity.}

\item{mid_prices}{Prices to match}

\item{spreads}{Spreads within which any match is tolerable}

\item{initial_vols_guess}{Initial set of volatilities to try in the root finder}

\item{use_impvol}{Judge fit quality on implied vol distance rather than price distance}

\item{relative_spread_tolerance}{Tolerance multiplier on bid-ask spreads taken from vol normalization}

\item{force_same_grid}{Price all options on the same grid, rather than having smaller timestep sizes for earlier maturities}

\item{num_time_steps}{Minimum number of time steps in the grid}

\item{const_short_rate}{A constant to use for the instantaneous interest rate in case \code{discount_factor_fcn}
is not given}

\item{const_default_intensity}{A constant to use for the instantaneous default intensity in case \code{default_intensity_fcn}
is not given}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring, with
arguments \code{T}, \code{t}}

\item{survival_probability_fcn}{A function for probability of survival, with
arguments \code{T}, \code{t} and \code{T>t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.  This argument is
only used in normalization of prices to vols for root finder tolerance, and
is therefore entirely optional}

\item{default_intensity_fcn}{A function for computing default intensity
occurring during this timestep, dependent on time and stock price, with
arguments \code{t}, \code{S}.  Should be consistent with
\code{survival_probability_fcn} if specified}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is}

\item{borrow_cost}{Stock borrow cost, affecting the drift rate}

\item{dividend_rate}{Continuous dividend rate, affecting the drift rate}

\item{...}{Futher arguments to \code{\link{find_present_value}}}
}
\value{
A list with two elements, \code{volatilities} and \code{cumulation_function}.  The \code{cumulation_function} will
  be a 2-parameter function giving cumulated variances, as created by code{\link{variance_cumulation_from_vols}}
}
\description{
Given a set of equity options with increasing tenors, along with
target prices for those options, and a set of equity-lined default
SDE parameters, fit a vector of piecewise constant
volatilities and an associated cumulative variance function
to them.
}
\details{
By default, the fitting happens in implied Black-Scholes volatility
space for better normalization.  That is to say, the fitting does pricing
using the \emph{full} SDE and PDE solver via \code{\link{find_present_value}}, but
judges fit quality on the basis of running resulting prices through a
nonlinear transformation that just
happens to come from the straight Black-Scholes model.
}
\seealso{
Other Implied Volatilities: \code{\link{american_implied_volatility}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_jump_process_volatility}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other Equity Dependent Default Intensity: \code{\link{find_present_value}},
  \code{\link{fit_to_option_market_df}},
  \code{\link{form_present_value_grid}},
  \code{\link{implied_jump_process_volatility}}
}
\concept{Equity Dependent Default Intensity}
\concept{Implied Volatilities}
\concept{implied volatility}
\keyword{Black-Scholes}
\keyword{calibration}
