/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders.arffFileReader;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;

public class DataRowWeka
implements DataRow {
    double[] data;
    Attributes atts;

    public DataRowWeka(Attributes atts_, String line) {
        this.atts = atts_;
        this.data = new double[this.atts.getNumberOfAttributes()];
        String[] parts = line.split(",");
        if (parts.length != this.atts.getNumberOfAttributes()) {
            throw new IllegalStateException("The number of columns does not match the number of attributes.");
        }
        block9: for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equals("?")) {
                this.data[i] = Double.NaN;
                continue;
            }
            switch (((StateSpaceType)this.atts.getFullListOfAttributes().get(i).getStateSpaceType()).getStateSpaceTypeEnum()) {
                case REAL: {
                    try {
                        this.data[i] = Double.parseDouble(parts[i]);
                    }
                    catch (Exception ex) {
                        System.out.println("Error Reading ARFF:");
                        System.out.println("Attribute Name: " + this.atts.getFullListOfAttributes().get(i).getName());
                        System.out.println("Error when reading value: " + parts[i]);
                        ex.printStackTrace();
                        new Exception();
                    }
                    continue block9;
                }
                case FINITE_SET: {
                    try {
                        FiniteStateSpace finiteStateSpace = (FiniteStateSpace)this.atts.getFullListOfAttributes().get(i).getStateSpaceType();
                        this.data[i] = finiteStateSpace.getIndexOfState(parts[i]);
                    }
                    catch (Exception ex) {
                        System.out.println("Error Reading ARFF:");
                        System.out.println("Attribute Name: " + this.atts.getFullListOfAttributes().get(i).getName());
                        System.out.print("Attribute States: ");
                        ((FiniteStateSpace)this.atts.getFullListOfAttributes().get(i).getStateSpaceType()).getStatesNames().stream().forEach(state -> System.out.print(state + ", "));
                        System.out.println();
                        System.out.println("Error when reading value: " + parts[i]);
                        new Exception();
                    }
                    continue block9;
                }
                case SPARSE_FINITE_SET: {
                    this.data[i] = Integer.parseInt(parts[i]);
                }
            }
        }
    }

    @Override
    public double getValue(Attribute att) {
        return this.data[att.getIndex()];
    }

    @Override
    public void setValue(Attribute att, double value) {
        this.data[att.getIndex()] = value;
    }

    @Override
    public Attributes getAttributes() {
        return this.atts;
    }

    @Override
    public double[] toArray() {
        return this.data;
    }
}

