/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.utils.Vector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SparseVector
implements Vector {
    Map<Integer, Double> values;
    final int dimension;

    public SparseVector(int dimension) {
        this.dimension = dimension;
        this.values = new HashMap<Integer, Double>();
    }

    @Override
    public double get(int i) {
        if (this.values.containsKey(i)) {
            return this.values.get(i);
        }
        return 0.0;
    }

    @Override
    public void set(int i, double val) {
        this.values.put(i, val);
    }

    @Override
    public int size() {
        return this.dimension;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (Double aDouble : this.values.values()) {
            sum += aDouble.doubleValue();
        }
        return sum;
    }

    @Override
    public void sum(Vector vector) {
        SparseVector sparseVector = (SparseVector)vector;
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) + sparseVector.get(integer));
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer)) continue;
            this.set(integer, sparseVector.get(integer));
        }
    }

    @Override
    public void substract(Vector vector) {
        SparseVector sparseVector = (SparseVector)vector;
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) - sparseVector.get(integer));
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer)) continue;
            this.set(integer, -sparseVector.get(integer));
        }
    }

    @Override
    public void copy(Vector vector) {
        SparseVector sparseVector = (SparseVector)vector;
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            this.set(integer, sparseVector.get(integer));
        }
    }

    @Override
    public void divideBy(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) / val);
        }
    }

    @Override
    public void multiplyBy(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) * val);
        }
    }

    @Override
    public void sumConstant(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) + val);
        }
    }

    @Override
    public double dotProduct(Vector vector) {
        SparseVector sparseVector = (SparseVector)vector;
        double sum = 0.0;
        for (Integer integer : this.getNonZeroEntries()) {
            sum += this.get(integer) * sparseVector.get(integer);
        }
        return sum;
    }

    @Override
    public boolean equalsVector(Vector vector, double threshold) {
        SparseVector sparseVector = (SparseVector)vector;
        for (Integer integer : this.getNonZeroEntries()) {
            if (!(Math.abs(this.get(integer) - sparseVector.get(integer)) > threshold)) continue;
            return false;
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer) || !(Math.abs(-sparseVector.get(integer)) > threshold)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String output() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Integer integer : this.getNonZeroEntries()) {
            stringBuilder.append("(");
            stringBuilder.append(integer);
            stringBuilder.append(",");
            stringBuilder.append(this.get(integer));
            stringBuilder.append(")");
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Set<Integer> getNonZeroEntries() {
        return this.values.keySet();
    }
}

