/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.datastream;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.variables.DynamicAssignment;

public interface DynamicDataInstance
extends DataInstance,
DynamicAssignment {
    @Override
    public long getSequenceID();

    @Override
    public long getTimeID();

    public double getValue(Attribute var1, boolean var2);

    public void setValue(Attribute var1, double var2, boolean var4);

    @Override
    default public double getValue(Attribute att) {
        return this.getValue(att, true);
    }

    @Override
    default public void setValue(Attribute att, double val) {
        this.setValue(att, val, true);
    }

    @Override
    default public double getValue(Variable var) {
        if (!var.isObservable()) {
            return Utils.missingValue();
        }
        if (var.isInterfaceVariable()) {
            return this.getValue(var.getAttribute(), false);
        }
        return this.getValue(var.getAttribute(), true);
    }

    @Override
    default public void setValue(Variable var, double val) {
        if (!var.isObservable()) {
            throw new IllegalArgumentException("Changing values of a non observable variable!");
        }
        if (var.isInterfaceVariable()) {
            this.setValue(var.getAttribute(), val, false);
        } else {
            this.setValue(var.getAttribute(), val, true);
        }
    }
}

