\name{randnet-package}
\alias{randnet-package}
\alias{randnet}
\docType{package}
\title{
Statistical modeling of random networks with model estimation, selection and
parameter tuning
}
\description{
The package provides model fitting and estimation functions for some
popular random network models. More importantly, it implements a general
cross-validation framework for model selection and parameter tuning
called ECV. Several other model selection methods are also included.
The work to build and improve this package is partially supported by the NSF
grants DMS-2015298 and DMS-2015134.
}
\details{
\tabular{ll}{
Package: \tab randnet\cr
Type: \tab Package\cr
Version: \tab 0.5\cr
Date: \tab 2022-01-01\cr
License: \tab GPL (>= 2)\cr
}
}
\author{
  Tianxi Li, Elizaveta Levina, Ji Zhu, Can M. Le\cr

Maintainer: Tianxi Li <tianxili@virginia.edu>

}
\references{
  T. Li, E. Levina, and J. Zhu. Network cross-validation by edge
  sampling. Biometrika, 107(2), pp.257-276, 2020.

  K. Chen and J. Lei. Network cross-validation for determining the number
  of communities in network data. Journal of the American Statistical
  Association, 113(521):241-251, 2018.

  K. Rohe, S. Chatterjee, and B. Yu. Spectral clustering and the
high-dimensional stochastic blockmodel. The Annals of Statistics, pages
1878-1915, 2011.

  A. A. Amini, A. Chen, P. J. Bickel, and E. Levina. Pseudo-likelihood
  methods for community detection in large sparse networks. The Annals
  of Statistics, 41(4):2097-2122, 2013.

  Qin, T. & Rohe, K. Regularized spectral clustering under the degree-corrected stochastic blockmodel Advances in Neural Information Processing Systems, 2013, 3120-3128

  J. Lei and A. Rinaldo. Consistency of spectral clustering in stochastic block models. The
  Annals of Statistics, 43(1):215-237, 2014.

  C. M. Le, E. Levina, and R. Vershynin. Concentration and regularization of random graphs.
  Random Structures & Algorithms, 2017.

  S. J. Young and E. R. Scheinerman. Random dot product graph models for
  social networks. In International Workshop on Algorithms and Models
  for the Web-Graph, pages 138-149. Springer, 2007.

  C. M. Le and E. Levina. Estimating the number of communities in networks by spectral
methods. arXiv preprint arXiv:1507.00827, 2015.

  Zhang, Y.; Levina, E. & Zhu, J. Estimating network edge probabilities by neighbourhood smoothing Biometrika, Oxford University Press, 2017, 104, 771-783


  B. Karrer and M. E. Newman. Stochastic blockmodels and community structure in networks.
  Physical Review E, 83(1):016107, 2011.

  Wang, Y. R. & Bickel, P. J. Likelihood-based model selection for
  stochastic block models The Annals of Statistics, Institute of
  Mathematical Statistics, 2017, 45, 500-528

  Gao, C.; Ma, Z.; Zhang, A. Y. & Zhou, H. H. Achieving optimal misclassification proportion in stochastic block models The Journal of Machine Learning Research, JMLR. org, 2017, 18, 1980-2024
  
    T. Li, E. Levina, and J. Zhu. Community models for networks observed through edge nominations. arXiv preprint arXiv:2008.03652 (2020).

  T. Li and C. M. Le, Network Estimation by Mixing: Adaptivity and More. arXiv preprint
arXiv:2106.02803, 2021.

R. Miao and T. Li. Informative core identification in complex networks. arXiv preprint arXiv:2101.06388, 2021

}
\keyword{ package }


