% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_convention.R
\name{argument_convention}
\alias{argument_convention}
\title{Standard Arguments}
\arguments{
\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{lookup_aag}{(\code{data.frame})\cr Additional metadata parameters.}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{paramu}{(\verb{character vector})\cr Parameter unit values.}

\item{visit_format}{(\code{character})\cr Type of visit. Options are "WEEK" and "CYCLE".}

\item{n_assessments}{(\code{integer})\cr Number of weeks or cycles.}

\item{n_days}{(\code{integer})\cr Number of days in each cycle (only used if \code{visit_format} is "CYCLE").}

\item{aval_mean}{(\verb{numeric vector})\cr Mean values corresponding to each parameter.}
}
\description{
The documentation to this function lists all the arguments in \code{random.cdisc.data}
that are used repeatedly in dataset creation.
}
\keyword{internal}
