% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radaette.R
\name{radaette}
\alias{radaette}
\title{Time to Adverse Event Analysis Dataset (ADAETTE)}
\usage{
radaette(
  adsl,
  event_descr = NULL,
  censor_descr = NULL,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(CNSR = c(NA, 0.1), AVAL = c(1234, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{event_descr}{(\verb{character vector})\cr Descriptions of events. Defaults to \code{NULL}.}

\item{censor_descr}{(\verb{character vector})\cr Descriptions of censors. Defaults to \code{NULL}.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADAETTE data \code{cadaette} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radaette} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function to generate random Time-to-AE Dataset for a
given Subject-Level Analysis Dataset.
}
\details{
Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adaette <- radaette(adsl, seed = 2)
adaette
}
\author{
Xiuting Mi
}
