% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radhy.R
\name{radhy}
\alias{radhy}
\title{Hy's Law Analysis Dataset (ADHY)}
\usage{
radhy(
  adsl,
  param = c("TBILI <= 2 times ULN and ALT value category",
    "TBILI > 2 times ULN and AST value category",
    "TBILI > 2 times ULN and ALT value category",
    "TBILI <= 2 times ULN and AST value category",
    "TBILI > 2 times ULN and ALKPH <= 2 times ULN and ALT value category",
    "TBILI > 2 times ULN and ALKPH <= 2 times ULN and AST value category",
    "TBILI > 2 times ULN and ALKPH <= 5 times ULN and ALT value category",
    "TBILI > 2 times ULN and ALKPH <= 5 times ULN and AST value category",
    "TBILI <= 2 times ULN and two consecutive elevations of ALT in relation to ULN", 
   
     "TBILI > 2 times ULN and two consecutive elevations of AST in relation to ULN",
    "TBILI <= 2 times ULN and two consecutive elevations of AST in relation to ULN",
    "TBILI > 2 times ULN and two consecutive elevations of ALT in relation to ULN",
    "TBILI > 2 times ULN and two consecutive elevations of ALT in relation to Baseline",
    "TBILI <= 2 times ULN and two consecutive elevations of ALT in relation to Baseline",
    "TBILI > 2 times ULN and two consecutive elevations of AST in relation to Baseline",
    
    
    "TBILI <= 2 times ULN and two consecutive elevations of AST in relation to Baseline",
    "ALT > 3 times ULN by Period", "AST > 3 times ULN by Period",
    "ALT or AST > 3 times ULN by Period", "ALT > 3 times Baseline by Period",
    "AST > 3 times Baseline by Period", "ALT or AST > 3 times Baseline by Period"),
  paramcd = c("BLAL", "BGAS", "BGAL", "BLAS", "BA2AL", "BA2AS", "BA5AL", "BA5AS",
    "BL2AL2CU", "BG2AS2CU", "BL2AS2CU", "BG2AL2CU", "BG2AL2CB", "BL2AL2CB", "BG2AS2CB",
    "BL2AS2CB", "ALTPULN", "ASTPULN", "ALTASTPU", "ALTPBASE", "ASTPBASE", "ALTASTPB"),
  seed = NULL,
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{cached}{boolean whether the cached ADHY data \code{cadhy} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radhy} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Hy's Law Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per subject per parameter per analysis visit per analysis date.

Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}, \code{AVISITN}, \code{ADTM}, \code{SRCSEQ}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adhy <- radhy(adsl, seed = 2)
adhy
}
\author{
wojciakw
}
