% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radpp.R
\name{radpp}
\alias{radpp}
\title{Pharmacokinetics Parameters Dataset (ADPP)}
\usage{
radpp(
  adsl,
  ppcat = c("Plasma Drug X", "Plasma Drug Y", "Metabolite Drug X", "Metabolite Drug Y"),
  ppspec = c("Plasma", "Plasma", "Plasma", "Matrix of PD", "Matrix of PD", "Urine",
    "Urine", "Urine", "Urine"),
  paramcd = c("AUCIFO", "CMAX", "CLO", "RMAX", "TON", "RENALCL", "RENALCLD", "RCAMINT",
    "RCPCINT"),
  param = c("AUC Infinity Obs", "Max Conc", "Total CL Obs", "Time of Maximum Response",
    "Time to Onset", "Renal CL", "Renal CL Norm by Dose", "Amt Rec from T1 to T2",
    "Pct Rec from T1 to T2"),
  paramu = c("day*ug/mL", "ug/mL", "ml/day/kg", "hr", "hr", "L/hr", "L/hr/mg", "mg",
    "\%"),
  aval_mean = c(200, 30, 5, 10, 3, 0.05, 0.005, 1.5613, 15.65),
  visit_format = "CYCLE",
  n_days = 2L,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(AVAL = c(NA, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{ppcat}{(\verb{character vector})\cr Categories of parameters.}

\item{ppspec}{(\verb{character vector})\cr Specimen material types.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramu}{(\verb{character vector})\cr Parameter unit values.}

\item{aval_mean}{(\verb{numeric vector})\cr Mean values corresponding to each parameter.}

\item{visit_format}{(\code{character})\cr Type of visit. Options are "WEEK" and "CYCLE".}

\item{n_days}{(\code{integer})\cr Number of days in each cycle (only used if \code{visit_format} is "CYCLE").}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADPP data \code{cadpp} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radpp} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Pharmacokinetics Parameters Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per study, subject, parameter category, parameter and visit.
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adpp <- radpp(adsl, seed = 2)
adpp
}
