% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radtr.R
\name{radtr}
\alias{radtr}
\title{Tumor Response Analysis Dataset (ADTR)}
\usage{
radtr(
  adsl,
  param = c("Sum of Longest Diameter by Investigator"),
  paramcd = c("SLDINV"),
  seed = NULL,
  cached = FALSE,
  ...
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{cached}{boolean whether the cached ADTR data \code{cadtr} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radtr} will be ignored.}

\item{...}{Additional arguments to be passed to \code{radrs}.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Tumor Response Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per subject per parameter per analysis visit per analysis date.

Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}, \code{BASETYPE}, \code{AVISITN}, \code{DTYPE}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adtr <- radtr(adsl, seed = 2)
adtr
}
\author{
tomlinsj, npaszty, Xuefeng Hou, dipietrc
}
