% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desScores.R
\name{plotDes}
\alias{plotDes}
\title{desScore plotting}
\usage{
plotDes(desScore, labels, colAv = "red", quantiles = FALSE)
}
\arguments{
\item{desScore}{object of type \code{desScore}.}

\item{labels}{labels used in the plot. Can be \code{NULL}.}

\item{colAv}{color of the line representing the average of the desirability scores in the plot.}

\item{quantiles}{\code{logical} whether the quantiles should be depicted in the plot.}
}
\description{
Plot of an \code{desScore} object.
}
\examples{
# compute the desirability scores of the full set of PBR(4)
sequences <- getAllSeq(rarPar(4))
issue1 <- corGuess("CS")
issue2 <- chronBias("linT", 1/4, "exact")
endp <- normEndp(mu = c(0,0), sigma = c(1,1))
A <- assess(sequences, issue1, issue2, endp = endp)
d1 <- derFunc(0.5, 0.75, 1)
d2 <- derFunc(0.05, 0.1, 1)

D <- getDesScores(A, d1, d2)
summary(D)
plotDes(D)
plotDes(D, quantiles = TRUE)

}
\seealso{
Other desirability topics: 
\code{\link{derFunc}},
\code{\link{evaluate}()},
\code{\link{getDesScores}()},
\code{\link{plotEv}()},
\code{\link{probUnDes}()}
}
\concept{desirability topics}
