% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSD.R
\name{GSD_OBF}
\alias{GSD_OBF}
\title{Simulate Group Sequential Design according to O'Brien and Fleming}
\usage{
GSD_OBF(n, norep, K, RP, approach)
}
\arguments{
\item{n}{total sample size}

\item{norep}{number of simulations to be conducted}

\item{K}{number of stages. (Currently available: \code{2,3} and \code{4})}

\item{RP}{the randomization procedure used.(Currently available: \code{'RAR'},
\code{'PBD2'}, \code{'BSD'} - BSD(3),BSD(5) and BSD(10), \code{'EBC'} - EBC(0.5),
 EBC(2/3) and EBC(0.8), \code{'CHEN'} - CHEN(2/3,3), CHEN(2/3,5) and CHEN(2/3,10) )}

\item{approach}{the approach used, where \code{1} corresponds to allocating all patients
at the begining of the trial and \code{2} corresponds to allocating patients for each
 stage separately (Only needed for \code{'RAR', 'BSD'} and \code{'CHEN'})}
}
\value{
A Dataframe with the mean type-I-error and go-no-go values for each stage of
a group sequential design study according to O'Brien and Fleming's design
}
\description{
Calculates the mean type-I-error and go-no-go value for each stage of a group
 sequential design study according to O'Brien and Fleming's design.
}
\examples{
# Simulate a GSD according to O'Brien and Fleming's design with 30 patients, 10 simulation runs,
# 3 Stages using Random Allocation Rule as a randomization procedure and applying it to
# all patients at the beginning
GSD_OBF(30,10,2,'RAR',1)
}
