% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_and_cluster_ra.R
\name{block_and_cluster_ra}
\alias{block_and_cluster_ra}
\title{Blocked and Clustered Random Assignment.}
\usage{
block_and_cluster_ra(clust_var, block_var, num_arms = NULL, block_m = NULL,
  prob_each = NULL, condition_names = NULL)
}
\arguments{
\item{clust_var}{A vector of length N that indicates which cluster each unit belongs to.}

\item{block_var}{A vector of length N that indicates which block each unit belongs to.}

\item{num_arms}{The total number of treatment arms. If unspecified, will be determined from the number of columns of block_m, the length of prob_each, or the length of condition_names.}

\item{block_m}{A matrix of arm sizes with blocks in the rows and treatment conditions in the columns. The rows should respect the alphabetical ordering of the blocks as determined by sort(unique(block_var). The columns should be in the order of condition_names, if specified.}

\item{prob_each}{A vector whose length is equal to the number of treatment assignments. When specified, prob_each assigns the same (within rounding) proportion of each block to each treatment condition, using complete random assignment. prob_each must sum to 1.}

\item{condition_names}{A character vector giving the names of the treatment conditions. If unspecified, the treatment conditions. will be named T1, T2, T3, etc.}
}
\value{
A vector of length N that indicates the treatment condition of each unit.
}
\description{
Random assignment where units are assigned as clusters and clusters are nested within blocks.
}
\examples{
clust_var <- rep(letters, times=1:26)
block_var <- rep(NA, length(clust_var))
block_var[clust_var \%in\% letters[1:5]] <- "block_1"
block_var[clust_var \%in\% letters[6:10]] <- "block_2"
block_var[clust_var \%in\% letters[11:15]] <- "block_3"
block_var[clust_var \%in\% letters[16:20]] <- "block_4"
block_var[clust_var \%in\% letters[21:26]] <- "block_5"

table(block_var, clust_var)

Z <- block_and_cluster_ra(clust_var = clust_var, block_var = block_var)

table(Z, clust_var)
table(Z, block_var)

Z <- block_and_cluster_ra(clust_var = clust_var, block_var = block_var, num_arms = 3)

table(Z, clust_var)
table(Z, block_var)

Z <- block_and_cluster_ra(clust_var = clust_var, block_var = block_var, prob_each = c(.2, .5, .3))

block_m <- rbind(c(2, 3),
                 c(1, 4),
                 c(3, 2),
                 c(2, 3),
                 c(5, 1))

Z <- block_and_cluster_ra(clust_var = clust_var, block_var = block_var, block_m = block_m)

table(Z, clust_var)
table(Z, block_var)
}

