% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_rs.R
\name{obtain_inclusion_probabilities}
\alias{obtain_inclusion_probabilities}
\title{Obtain inclusion probabilities}
\usage{
obtain_inclusion_probabilities(rs_declaration = NULL, N = NULL,
  strata_var = NULL, clust_var = NULL, n = NULL, prob = NULL,
  strata_n = NULL, strata_prob = NULL, simple = FALSE)
}
\arguments{
\item{rs_declaration}{A random sampling declaration, created by \code{\link{declare_rs}}.}

\item{N}{The number of units. N must be a positive integer. (required)}

\item{strata_var}{A vector of length N that indicates which stratum each unit belongs to.}

\item{clust_var}{A vector of length N that indicates which cluster each unit belongs to.}

\item{n}{Use for a design in which n units (or clusters) are sampled. (optional)}

\item{prob}{Use for a design in which either floor(N*prob) or ceiling(N*prob) units (or clusters) are sampled. The probability of being sampled is exactly prob because with probability 1-prob, floor(N*prob) units (or clusters) will be sampled and with probability prob, ceiling(N*prob) units (or clusters) will be sampled. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{strata_n}{Use for a design in which strata_n describes the number of units to sample within each stratum.}

\item{strata_prob}{Use for a design in which strata_prob describes the probability of being sampled within each stratum. Differs from prob in that the probability of assignment can vary across strata.}

\item{simple}{logical, defaults to FALSE. If TRUE, simple random assignment is used. When simple = TRUE, please do not specify n or strata_n.}
}
\description{
You can either give obtain_inclusion_probabilities() an rs_declaration, as created by \code{\link{declare_rs}} or you can specify the other arguments to describe a random sampling procedure.\cr \cr
This function is especially useful when units have different inclusion probabilties and the analyst plans to use inverse-probability weights.
}
\examples{

# Draw a stratified random sample
strata_var <- rep(c("A", "B","C"), times=c(50, 100, 200))

declaration <- declare_rs(strata_var = strata_var)

observed_probabilities <-
   obtain_inclusion_probabilities(rs_declaration = declaration)

table(strata_var, observed_probabilities)


# Sometimes it is convenient to skip the declaration step
observed_probabilities <-
   obtain_inclusion_probabilities(strata_var = strata_var)

table(strata_var, observed_probabilities)

}
