\name{runifInterface}
\alias{runifInterface}
\alias{set.generator}
\alias{put.description}
\alias{get.description}
\title{Functions for using runif() and rnorm() with randtoolbox generators}
\description{
These functions allow to set some of the random number generators from randtoolbox
package so that it can be used in the standard R functions, which use random numbers,
for example \code{runif()}, \code{rnorm()}, \code{sample()} and
also \code{set.seed()}.
}
\usage{
set.generator <- function(name=c("congruRand", "WELL", "default"), 
parameters=NULL, seed=NULL, ..., only.dsc=FALSE)
put.description(description)		
get.description()
}
\arguments{
	\item{name}{a character string for the RNG name.}
	\item{parameters}{a numeric or character vector describing a RNG from the family
           specified by the \code{name} parameter.}
	\item{seed}{a number to be used as a seed}	
	\item{...}{arguments describing the components of the vector parameters,
           if argument \code{parameters} is NULL.}	
	\item{only.dsc}{a logical. If \code{TRUE} the description of a RNG is created,
           but the generator is not initialized.}
	\item{description}{a list describing a generator as created by \code{set.generator()}}
           or \code{get.description()}
}
\details{
Random number generators provided by R extension packages are set using \code{RNGkind("user-supplied")}.
The package \pkg{randtoolbox} assumes that this function is not called by the user directly.
Instead, it is called from the functions \code{set.generator()} and \code{put.description()} used
for setting some of a larger collection of the supported generators.

Random number generators in \pkg{randtoolbox} are represented at the R level by a list
containing mandatory components \code{name, parameters, state} and possibly an
optional component \code{authors}. The function \code{set.generator()} internally
creates this list from the user supplied information and then runs \code{put.description()}
on this list in order to really initialize the generator for the functions \code{runif()}
and \code{set.seed()}. If \code{set.generator()} is called with the parameter
\code{only.dsc=TRUE}, then the generator is not initialized and only
its description is created. If the generator is initialized, then the function
\code{get.description()} may be used to get the actual
state of the generator, which may be stored and used later in \code{put.description()}
to continue the sequence of the random numbers from the point, where \code{get.description()}
was called. This may be used, for example, to alternate between the streams of random numbers
generated by different generators.
}
\value{
\code{set.generator()} with the parameter \code{only.dsc=TRUE} and
\code{get.description()} return the list describing a generator.
\code{put.description()} with the parameter \code{only.dsc=TRUE} (the default)
and \code{put.description()} return \code{NULL}.
}
\seealso{
\code{RNGkind}
}
\author{
 Petr Savicky and Christophe Dutang
}
\examples{
RNGkind() # [1] "Mersenne-Twister" "Inversion"   

#parameters for Park Miller congruential generator
paramParkMiller <- c(mod=2^31-1, mult=16807, incr=0)
set.generator(name="congruRand", parameters=paramParkMiller, seed=1)

RNGkind() # [1] "user-supplied" "Inversion"

#description of the RNG set by set.generator(), i.e. Park Miller
print(ParkMiller <- get.description())

#generate 10 random points from the Park-Miller sequence
x1 <- runif(10)

#the seed has changed
get.description()

# the Knuth Lewis RNG
paramKnuthLewis <- c(mod="4294967296", mult="1664525", incr="1013904223")
set.generator(name="congruRand", parameters= paramKnuthLewis, seed=1)

#description of the current RNG, i.e. Knuth Lewis
KLwithseed1 <- get.description()

x2 <- runif(10)

#reinitiate the RNG setting
put.description(ParkMiller)

#the same as x1
x1 == runif(10)

#set WELL RNGs
set.generator("WELL", seed=12345, order=1024, version="a")
get.description()

#get back to the original R setting
set.generator("default")
RNGkind()

}
\keyword{distribution}

