% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapCanvas-methods.R
\name{global.bbox.save}
\alias{global.bbox}
\alias{global.bbox.fetch}
\alias{global.bbox.save}
\title{Global bounding box}
\usage{
global.bbox.save(con, ...)

global.bbox.fetch(con)
}
\arguments{
\item{con}{An \code{SQLiteConnection} object pointing to a
\code{rangeMapper} project}

\item{\dots}{Arguments to pass to the corresponding methods: \cr
\emph{bbox} can be a \code{character} vector; the path to the range files directory
\emph{bbox} can also be an object inheriting from \code{\linkS4class{Spatial}} \cr
\emph{p4s} an object of class \code{\linkS4class{CRS}} \cr}
}
\description{
Computes, sets or retrieves the global spatial bounding box.
}
\details{
\code{global.bbox.save} saves the \emph{global bounding box} and the
\emph{proj4} string to the sqlite database.\cr \code{global.bbox.fetch}
retrieves the \emph{global bounding box} as a
\code{\link{SpatialPolygonsDataFrame}}.
}
\note{
If \emph{bbox} is a \code{character} vector then the corresponding
            method calls \code{rangeMapBbox} with \code{checkProj = TRUE} which requires
            all ranges to have the same \emph{proj4} argument.  \cr If \emph{p4s} is set
            then the \emph{bbox} will be set with that \emph{p4s} string else the
            \emph{p4s} will be identical with the \emph{proj4} string of the range
            files. \cr If \emph{bbox} and \emph{p4s} are missing then an unprojected
            global bounding box is set.
}
\examples{
require(rangeMapper)
wd = tempdir()

f= system.file(package = "rangeMapper", "extdata", "wrens", "vector")

# Using default values for both bbox and p4s
dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = wd )
global.bbox.save(con = dbcon)
bbox0 = global.bbox.fetch(dbcon)

plot(bbox0, axes = TRUE)

}

