% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spatial.R
\docType{methods}
\name{WKT2SpatialPolygonsDataFrame}
\alias{WKT2SpatialPolygonsDataFrame}
\alias{vertices}
\alias{vertices,SpatialPolygons-method}
\title{Convert WKT polygons to SpatialPolygonsDataFrame}
\usage{
WKT2SpatialPolygonsDataFrame(dat, geom, id)

vertices(object, FUN)

\S4method{vertices}{SpatialPolygons}(object, FUN)
}
\arguments{
\item{dat}{\code{data.frame}}

\item{geom}{is the name (character vector) of the column in the
\code{data.frame} containing the geometry.}

\item{id}{is the name (character vector) of the column in the
\code{data.frame} identifying the polygon.  when \code{id} is not unique
then polygons are combined using \code{\link[rgeos]{gUnionCascaded}}.}

\item{object}{An object.}

\item{FUN}{A function.}
}
\value{
a \code{\link[sp]{SpatialPolygonsDataFrame} }object.

A \link[sp]{SpatialPointsDataFrame} containing an id column
          corresponding to each extracted Polygon.
}
\description{
Convert a data.frame containing WKT polygons to a \code{SpatialPolygonsDataFrame}.

Extract vertices from a \link[sp]{SpatialPolygonsDataFrame} and optionally
applies an aggregating function to each Polygon.
}
\examples{

require(rangeMapper)
require(rgeos)

# generate a few random polygons
randPoly = function(mean, sd) {
  writeWKT(
    gConvexHull(
     readWKT(paste("MULTIPOINT (",
             paste(apply(matrix(rnorm(n= 100, mean, sd), ncol = 2), 1,
             paste, collapse = ' '), collapse = ","), ")"))))
}
n = 50
d = data.frame( nam = sample(letters, n, TRUE),
               range = mapply(randPoly, mean = sample(1:2, n, TRUE),
               sd = sample(1:2/5, n, TRUE) ))


X = WKT2SpatialPolygonsDataFrame(d, 'range', 'nam')


dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = tempdir() )
global.bbox.save(con = dbcon, bbox = X)
gridSize.save(dbcon)
canvas.save(dbcon)
processRanges(spdf = X, con =  dbcon, ID = "nam")
rangeMap.save(dbcon)
plot(rangeMap.fetch(dbcon))

require(rangeMapper)
require(rgdal)
f = system.file(package = "rangeMapper", "extdata", "wrens", "vector")
# path to Campylorhynchus_gularis breeding range:
camgul = selectShpFiles(f, ogr = TRUE, polygons.only = TRUE)[6, ]
r = readOGR(camgul$dsn, camgul$layer)
mp = vertices(r, mean)
v = vertices(r)

plot(r)
points(mp, col = 2, pch = 3, cex = 2)
points(v, pch = 3, cex = .5)

}
