% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heat.R
\name{PlotHeat}
\alias{PlotHeat}
\title{Illustrate heat plot for treatment ranking}
\usage{
PlotHeat(data, sorttx = NULL, rotateX = NULL, szFntY = NULL)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{sorttx}{LOGIC value for indicating whether sort heat plot by treatments.}

\item{rotateX}{NUMERIC value between 0 and 360 for rotating x axis labels of
heat plot.}

\item{szFntY}{NUMERIC value for indicating font size of outcome name(s).}
}
\value{
\strong{PlotHeat()} returns a heat plot.
}
\description{
\strong{PlotHeat()} is a function for illustrating heat plot.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#nma.1 <- GetMetrics(nma, outcome = "HbA1c.random", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)
#nma.2 <- GetMetrics(nma, outcome = "HbA1c.common", prefer = "small", metrics = "SUCRA",
#model = "common", simt = 1000)

# Combine metrics of multiple outcomes
#dataMetrics <- rbind(nma.1, nma.2)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate heat plot
#PlotHeat(data = dataRankinma)
## End(Not run)

}
\seealso{
\code{\link{GetMetrics}}, \code{\link{SetMetrics}},
\code{\link{PlotBeads}}, \code{\link{PlotBar}},
\code{\link{PlotLine}}, \code{\link{PlotSpie}}
}
