/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.util.ObjectStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        List<ComparableEvent> eventsToCompare;
        int numEvents;
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort = this.trainingParameters.getBooleanParameter("sort", true);
        long start = System.currentTimeMillis();
        this.display("Indexing events with TwoPass using cutoff of " + cutoff + "\n\n");
        this.display("\tComputing event counts...  ");
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        File tmp = File.createTempFile("events", null);
        tmp.deleteOnExit();
        try (BufferedWriter osw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), StandardCharsets.UTF_8));){
            numEvents = this.computeEventCounts(eventStream, osw, predicateIndex, cutoff);
        }
        this.display("done. " + numEvents + " events\n");
        this.display("\tIndexing...  ");
        try (FileEventStream fes = new FileEventStream(tmp);){
            eventsToCompare = this.index(fes, predicateIndex);
        }
        tmp.delete();
        this.display("done.\n");
        if (sort) {
            this.display("Sorting and merging events... ");
        } else {
            this.display("Collecting events... ");
        }
        this.sortAndMerge(eventsToCompare, sort);
        this.display(String.format("Done indexing in %.2f s.\n", (double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private int computeEventCounts(ObjectStream<Event> eventStream, Writer eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        int eventCount = 0;
        while ((ev = eventStream.read()) != null) {
            ++eventCount;
            eventStore.write(FileEventStream.toLine(ev));
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, counter);
        }
        String[] predicateSet = (String[])counter.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= cutoff).map(Map.Entry::getKey).sorted().toArray(String[]::new);
        this.predCounts = new int[predicateSet.length];
        for (int i = 0; i < predicateSet.length; ++i) {
            this.predCounts[i] = (Integer)counter.get(predicateSet[i]);
            predicatesInOut.put(predicateSet[i], i);
        }
        return eventCount;
    }
}

