% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colAggregators}
\alias{colAggregators}
\alias{colMedians}
\alias{colProds}
\alias{colSds}
\alias{colMediansMasked}
\alias{colMeansMasked}
\alias{colSdsMasked}
\title{Fast matrix column aggregators}
\usage{
colMedians(x)

colProds(x)

colSds(x)

colMediansMasked(x, mask)

colMeansMasked(x, mask)

colSdsMasked(x, mask)
}
\arguments{
\item{x}{A numeric matrix to compute column aggregates of.}

\item{mask}{A logical matrix determining which data points to include in 
the column-wise aggregations.}
}
\value{
A numeric vector representing values aggregated by column.
}
\description{
Fast matrix column aggregators
}
\examples{
x <- cbind(x1 = 3, x2 = c(4:1, 2:5))
colMedians(x)

colProds(x)

colSds(x)

mask<-cbind(rep(c(TRUE,FALSE),4),
            rep(c(TRUE,FALSE),each=4))
colMediansMasked(x,mask)

colMeansMasked(x,mask)

colSdsMasked(x,mask)

}
\seealso{
\link[base]{colMeans}, \link{mediansByMask}, \link{maskAggregators}
}
