% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapSolved.R
\name{amount.held}
\alias{amount.held}
\alias{amount.held.RapSolved}
\title{Extract amount held for a solution}
\usage{
amount.held(x, y, species)

\method{amount.held}{RapSolved}(x, y = 0, species = NULL)
}
\arguments{
\item{x}{\code{RapResults} or \code{RapSolved} object.}

\item{y}{\code{NULL} to return all values, \code{integer} 0 to return values for best solution, \code{integer} value greater than 0 for \code{y}'th solution value.}

\item{species}{\code{NULL} for all species or \code{integer} indicating species.}
}
\value{
\code{matrix} or \code{numeric} vector depending on arguments.
}
\description{
This function returns the amount held for each species in a solution.
}
\examples{
data(sim_rs)
# amount held (\\\%) in best solution for each species 
amount.held(sim_rs, 0)
# amount held (\\\%) in best solution for species 1
amount.held(sim_rs, 0, 1)
# amount held (\\\%) in second solution for each species 
amount.held(sim_rs, 2)
# amount held (\\\%) in each solution for each species
amount.held(sim_rs, NULL)
}
\seealso{
\code{RapResults}, \code{RapSolved}.
}

