% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapResults.R, R/RapSolved.R
\name{score}
\alias{score}
\alias{score.RapResults}
\alias{score.RapSolved}
\title{Solution score}
\usage{
score(x, y)

\method{score}{RapResults}(x, y = 0)

\method{score}{RapSolved}(x, y = 0)
}
\arguments{
\item{x}{\code{RapResults} or \code{RapSolved} object.}

\item{y}{"NULL" to return all scores, "integer" 0 to return score for best solution, "integer" value greater than 0 for \code{y}'th solution score.}
}
\value{
"matrix" or "numeric" vector with solution score(s) depending on arguments.
}
\description{
Extract solution score from \code{RapResults} or \code{RapSolved} object.
}
\examples{
# load data
data(sim_rs)
# score for best solution
score(sim_rs, 0)
# score for second solution
score(sim_rs, 2)
# score for all solutions
score(sim_rs, NULL)
}
\seealso{
\code{RapResults}, \code{RapSolved}.
}

