% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSpeciesAverageInPus.R
\name{calcSpeciesAverageInPus}
\alias{calcSpeciesAverageInPus}
\alias{calcSpeciesAverageInPus.SpatialPolygons}
\alias{calcSpeciesAverageInPus.SpatialPolygonsDataFrame}
\alias{calcSpeciesAverageInPus.sf}
\title{Calculate average value for species data in planning units}
\usage{
calcSpeciesAverageInPus(x, ...)

\method{calcSpeciesAverageInPus}{SpatialPolygons}(x, y, ids = seq_len(terra::nlyr(y)), ...)

\method{calcSpeciesAverageInPus}{SpatialPolygonsDataFrame}(x, y, ids = seq_len(terra::nlyr(y)), field = NULL, ...)

\method{calcSpeciesAverageInPus}{sf}(x, y, ids = seq_len(terra::nlyr(y)), field = NULL, ...)
}
\arguments{
\item{x}{\code{\link[sf:st_as_sf]{sf::st_as_sf()}} object.}

\item{...}{not used.}

\item{y}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{ids}{\code{integer} vector of ids. Defaults to indices of layers in
argument to \code{y}.}

\item{field}{\code{integer} index or \code{character} name of column with
planning unit ids. Valid only when \code{x} is a
\code{\link[sf:sf]{sf::st_sf()}} or \code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} object.
Default behavior is to treat each polygon as a different planning unit.}
}
\value{
A \code{\link[base:data.frame]{base::data.frame()}} object.
}
\description{
This function calculates the average of species values in each planning unit.
By default all polygons will be treated as having separate ids.
}
\section{Note}{

Although earlier versions of the package had an additional \code{ncores}
parameter, this parameter has been deprecated.
}

\examples{
\dontrun{
# simulate data
sim_pus <- sim.pus(225L)
sim_spp <- terra::rast(
  lapply(c("uniform", "normal", "bimodal"),
         sim.species, n = 1, res = 1, x = sim_pus)
)

# calculate average for 1 species
puvspr1.dat <- calcSpeciesAverageInPus(sim_pus, sim_spp[[1]])

# calculate average for multiple species
puvspr2.dat <- calcSpeciesAverageInPus(sim_pus, sim_spp)
}
}
