# Author: Robert J. Hijmans
# Date : March 2011
# Version 1.0
# Licence GPL v3


if (!isGeneric("atan2")) {
	setGeneric("atan2", function(y, x)
		standardGeneric("atan2"))
}	

setMethod("atan2", signature(y='RasterLayer', x='RasterLayer'),
	function(y, x) { 
	
		r <- raster(x)
		compare(r, y)
 
		if (canProcessInMemory(r, 3)) {
			r <- setValues(r, atan2(getValues(y), getValues(x)))
		} else {
			tr <- blockSize(x)
			pb <- pbCreate(tr$n, type=.progress())
			r <- writeStart(r, filename=rasterTmpFile())
			for (i in 1:tr$n) {
				v <- atan2(getValuesBlock(y, row=tr$row[i], nrows=tr$size), getValuesBlock(x, row=tr$row[i], nrows=tr$size) ) 
				r <- writeValues(r, v, tr$row[i])
				pbStep(pb, i) 
			}
			r <- writeStop(r)
			pbClose(pb)
		}
		return(r)
	}
)

