## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ratPASTA)


## ----loadData, echo = FALSE, results = FALSE, include = FALSE-----------------
df <- readRDS("data.RDS")


## ----summary------------------------------------------------------------------
summariseStartle(df)


## ----plot1, fig.height = 9----------------------------------------------------
basicStartlePlot(df, n_col = 3)



## ----plot1.2------------------------------------------------------------------
basicStartlePlot(df, filter_groups = "ctr 5")



## ----plot2--------------------------------------------------------------------
startlePlot(df, type = 1)



## ----plot3--------------------------------------------------------------------
startlePlot(df, type = 2)



## ----plot4--------------------------------------------------------------------
startlePlot(df, type = 3)



## ----plot5--------------------------------------------------------------------
startlePlot(df, type = 4)



## ----list---------------------------------------------------------------------
l <- latencyPlot(df)



## ----printList----------------------------------------------------------------
print(l$LatencyVsCycle)
print(l$LatencyVsGroup)


