# SCCS @(#)survexp.mn.s	4.2 11/22/94
#
# Create the Minnesota total hazards table
#   The raw numbers below are q* 10^5.  Note that there are 24 leap years/100
#
survexp.mn  <- {
    temp <- c(
     1975,123,85,73,58,53,50,48,44,38,33,32,38,55,79,107,134,158,176,189,203,
     220,226,217,195,168,144,127,123,127,135,143,150,155,159,165,176,192,214,
     240,269,300,335,375,421,471,525,581,638,699,761,833,920,1028,1152,1289,
     1430,1566,1693,1817,1943,2085,2252,2454,2691,2960,3248,3538,3812,4073,
     4324,4602,4950,5407,5960,6574,7196,7822,8439,9068,9785,10609,11476,12340,
     13203,14266,15539,16875,18181,19442,20736,22169,23684,25237,26697,27962,
     29090,30135,31111,32017,32857,33633,34347,35004,35606,36157,36661,37121,
     37540,37922,1436,84,71,52,39,38,34,31,28,26,23,22,24,30,38,48,58,64,66,65,
     62,61,59,59,60,62,62,64,67,72,77,84,90,94,99,103,110,118,130,143,157,172,
     189,208,229,252,277,303,329,357,386,419,454,494,539,588,642,699,758,821,
     892,972,1058,1148,1248,1356,1481,1636,1825,2043,2276,2522,2797,3111,3467,
     3855,4271,4734,5253,5832,6486,7206,7972,8773,9633,10722,11992,13284,14490,
     15639,16899,18378,19958,21560,23109,24584,25854,26980,27996,28949,29836,
     30659,31420,32122,32768,33361,33904,34401,34855,35269,1171,82,66,57,45,38,
     35,32,28,23,19,19,28,44,66,88,106,122,135,146,158,169,174,172,164,153,144,
     136,131,128,126,124,123,126,131,139,148,158,169,180,194,213,234,259,287,
     317,353,400,457,523,593,663,733,801,870,943,1023,1116,1228,1358,1500,1653,
     1828,2025,2240,2473,2716,2962,3204,3450,3711,3997,4316,4674,5074,5510,
     5982,6503,7075,7696,8374,9104,9872,10673,11521,12563,13713,14881,16025,
     17187,18480,19966,21563,23177,24710,26149,27438,28654,29797,30867,31865,
     32792,33650,34443,35174,35845,36461,37024,37539,38009,903,56,45,36,31,30,
     28,25,23,20,17,16,18,22,28,35,40,44,47,49,51,53,53,53,50,48,46,45,45,47,
     49,52,55,60,65,72,80,89,99,110,122,135,150,165,181,198,217,238,260,282,
     305,330,359,395,436,482,529,578,627,678,733,795,868,954,1051,1159,1274,
     1393,1514,1643,1783,1942,2129,2351,2604,2874,3167,3508,3914,4384,4903,
     5459,6067,6733,7467,8396,9429,10503,11595,12752,14085,15604,17184,18743,
     20278,21823,23221,24560,25834,27040,28176,29242,30237,31163,32023,32817,
     33550,34224,34843,35411)

    temp2 <- -log(1- temp/100000)/365.24    #daily hazard rate

    #Add in the extrapolated data for 1990 and 2000
    temp <- array(0, c(110,2,4))
    temp[,,1:2] <- temp2
    fix  <- c(.00092*(0:109) - .1615, .00020*(0:109) - .1746)
    temp[,,3]   <- exp(log(temp[,,2]) + fix)
    temp[,,4]   <- exp(log(temp[,,3]) + fix)

    attributes(temp) <- list (
	dim      =c(110,2,4),
	dimnames =list(0:109, c("male", "female"), 10 * 197:200),
	dimid    =c("age", "sex", "year"),
	factor   =c(0,1,10),
	cutpoints=list(0:109 * 365.24, NULL, mdy.date(1,1, 197:200*10)),
	summary = function(R) {
		     x <- c(format(round(min(R[,1]) /365.24, 1)),
			    format(round(max(R[,1]) /355.24, 1)),
			    sum(R[,2]==1), sum(R[,2]==2))
		     x2<- as.character(as.date(c(min(R[,3]), max(R[,3]))))

		     paste("  age ranges from", x[1], "to", x[2], "years\n",
			   " male:", x[3], " female:", x[4], "\n",
			   " date of entry from", x2[1], "to", x2[2], "\n")
		     },
	class='ratetable')
    temp
    }
