% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preset-aaa.R, R/preset-analysis-electrode.R,
%   R/preset-analysis-range.R, R/preset-baseline-choices.R,
%   R/preset-condition-groups.R, R/preset-import-export-pipeline.R,
%   R/preset-import-setup-blocks.R, R/preset-import-setup-channels.R,
%   R/preset-import-setup-subject.R, R/preset-loader-3dviewer.R,
%   R/preset-loader-electrode.R, R/preset-loader-epoch.R,
%   R/preset-loader-project.R, R/preset-loader-reference.R,
%   R/preset-loader-subject.R, R/preset-sync-settings.R
\name{rave-ui-preset}
\alias{rave-ui-preset}
\alias{presets_analysis_electrode_selector2}
\alias{presets_analysis_ranges}
\alias{presets_baseline_choices}
\alias{presets_condition_groups}
\alias{presets_import_export_subject_pipeline}
\alias{presets_import_setup_blocks}
\alias{presets_import_setup_channels}
\alias{presets_import_setup_native}
\alias{presets_loader_3dviewer}
\alias{presets_loader_3dviewer2}
\alias{presets_loader_electrodes}
\alias{presets_loader_epoch}
\alias{presets_loader_project}
\alias{presets_loader_reference}
\alias{presets_loader_subject}
\alias{presets_loader_subject_only}
\alias{presets_loader_sync_project_subject}
\title{Preset reusable front-end components for 'RAVE' modules}
\usage{
presets_analysis_electrode_selector2(
  id = "electrode_text",
  varname = "analysis_electrodes",
  label = "Select Electrodes",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  pipeline_repository = "repository",
  start_simple = FALSE,
  multiple = TRUE
)

presets_analysis_ranges(
  id = "analysis_ranges",
  varname = "analysis_ranges",
  label = "Configure Analysis",
  pipeline_repository = "repository",
  max_components = 2
)

presets_baseline_choices(
  id = "baseline_choices",
  varname = "baseline",
  label = "Baseline Settings",
  pipeline_repository = "repository",
  baseline_choices = c("Decibel", "\% Change Power", "\% Change Amplitude",
    "z-score Power", "z-score Amplitude"),
  baseline_along_choices = c("Per frequency, trial, and electrode", "Across electrode",
    "Across trial", "Across trial and electrode")
)

presets_condition_groups(
  id = "condition_groups",
  varname = "condition_groups",
  label = "Create Condition Contrast",
  pipeline_repository = "repository"
)

presets_import_export_subject_pipeline(
  id = "im_ex_pipeline",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  pipeline_repository = "repository",
  settings_entries = c("loaded_electrodes", "epoch_choice", "epoch_choice__trial_starts",
    "epoch_choice__trial_ends", "reference_name"),
  fork_mode = c("exclude", "include")
)

presets_import_setup_blocks(
  id = "import_blocks",
  label = "Format & session blocks",
  import_setup_id = "import_setup",
  max_components = 5
)

presets_import_setup_channels(
  id = "import_channels",
  label = "Channel information",
  import_setup_id = "import_setup",
  import_blocks_id = "import_blocks"
)

presets_import_setup_native(
  id = "import_setup",
  label = "Select project & subject"
)

presets_loader_3dviewer(
  id = "loader_3d_viewer",
  height = "600px",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  loader_reference_id = "loader_reference_name",
  loader_electrodes_id = "loader_electrode_text",
  gadgets = c("standalone", "download")
)

presets_loader_3dviewer2(
  id = "loader_3d_viewer",
  height = "600px",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  loader_electrodes_id = "loader_electrode_text",
  gadgets = c("standalone", "download")
)

presets_loader_electrodes(
  id = "loader_electrode_text",
  varname = "loaded_electrodes",
  label = "Electrodes",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code"
)

presets_loader_epoch(
  id = "loader_epoch_name",
  varname = "epoch_choice",
  label = "Epoch and Trial Duration",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code"
)

presets_loader_project(
  id = "loader_project_name",
  varname = "project_name",
  label = "Project"
)

presets_loader_reference(
  id = "loader_reference_name",
  varname = "reference_name",
  label = "Reference name",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  mode = c("default", "create")
)

presets_loader_subject(
  id = "loader_subject_code",
  varname = "subject_code",
  label = "Subject",
  loader_project_id = "loader_project_name",
  checks = c("notch", "wavelet")
)

presets_loader_subject_only(
  id = "loader_subject_code",
  varname = "subject_code",
  label = "Subject",
  multiple = FALSE
)

presets_loader_sync_project_subject(
  id = "loader_sync_project_subject",
  label = "Sync subject from most recently loaded",
  varname = "loader_sync_project_subject",
  loader_project_id = "loader_project_name",
  loader_subject_id = "loader_subject_code",
  from_module = NULL,
  project_varname = "project_name",
  subject_varname = "subject_code"
)
}
\arguments{
\item{id}{input or output ID of the element; this ID will be prepended with
module namespace}

\item{varname}{variable name(s) in the module's settings file}

\item{label}{readable label(s) of the element}

\item{loader_project_id}{the ID of \code{presets_loader_project} if
different to the default}

\item{loader_subject_id}{the ID of \code{presets_loader_subject} if
different to the default}

\item{pipeline_repository}{the pipeline name that represents the 'RAVE'
repository from functions such as \code{\link[raveio]{prepare_subject_bare}},
\code{\link[raveio]{prepare_subject_with_epoch}}, and
\code{\link[raveio]{prepare_subject_power}}}

\item{start_simple}{whether to start in simple view and hide optional inputs}

\item{multiple}{whether to allow multiple inputs}

\item{max_components}{maximum number of components for compound inputs}

\item{baseline_choices}{the possible approaches to calculate baseline}

\item{baseline_along_choices}{the units of baseline}

\item{settings_entries}{used when importing pipelines, pipeline variable
names to be included or excluded, depending on \code{fork_mode}}

\item{fork_mode}{\code{'exclude'} (default) or \code{'include'}; in
\code{'exclude'} mode, \code{settings_entries} will be excluded from the
pipeline settings; in \code{'include'} mode, only \code{settings_entries}
can be imported.}

\item{import_setup_id}{the ID of \code{presets_import_setup_native} if
different to the default}

\item{import_blocks_id}{the ID of \code{presets_import_setup_blocks} if
different to the default}

\item{height}{height of the element}

\item{loader_reference_id}{the ID of \code{presets_loader_reference} if
different to the default}

\item{loader_electrodes_id}{the ID of \code{presets_loader_electrodes} if
different to the default}

\item{gadgets}{gadget types to include; see \code{type} argument in function
\code{\link{output_gadget}}}

\item{mode}{whether to create new reference, or simply to choose from
existing references}

\item{checks}{whether to check if subject has been applied with 'Notch'
filters or 'Wavelet'; default is both.}

\item{from_module}{which module to extract input settings}

\item{project_varname, subject_varname}{variable names that should be
extracted from the settings file}
}
\value{
A \code{'RAVEShinyComponent'} instance.
}
\description{
For examples and use cases, please check
\code{\link{new_rave_shiny_component_container}}.
}
\seealso{
\code{\link{new_rave_shiny_component_container}}
}
