% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-result.R
\name{PipelineResult}
\alias{PipelineResult}
\title{Pipeline result object}
\value{
\code{TRUE} if the target is finished, or \code{FALSE} if
timeout is reached
}
\description{
Pipeline result object

Pipeline result object
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{progressor}}{progress bar object, usually generated a progress
instance}

\item{\code{promise}}{a \code{\link[promises]{promise}} instance that monitors
the pipeline progress}

\item{\code{verbose}}{whether to print warning messages}

\item{\code{names}}{names of the pipeline to build}

\item{\code{async_callback}}{function callback to call in each check loop;
only used when the pipeline is running in \code{async=TRUE} mode}

\item{\code{check_interval}}{used when \code{async=TRUE} in
\code{\link{pipeline_run}}, interval in seconds to check the progress}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{variables}}{target variables of the pipeline}

\item{\code{variable_descriptions}}{readable descriptions of the target variables}

\item{\code{valid}}{logical true or false whether the result instance hasn't
been invalidated}

\item{\code{status}}{result status, possible status are \code{'initialize'},
\code{'running'}, \code{'finished'}, \code{'canceled'},
and \code{'errored'}. Note that \code{'finished'} only means the pipeline
process has been finished.}

\item{\code{process}}{(read-only) process object if the pipeline is running in
\code{'async'} mode, or \code{NULL}; see \code{\link[callr]{r_bg}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipelineResult-validate}{\code{PipelineResult$validate()}}
\item \href{#method-PipelineResult-invalidate}{\code{PipelineResult$invalidate()}}
\item \href{#method-PipelineResult-get_progress}{\code{PipelineResult$get_progress()}}
\item \href{#method-PipelineResult-new}{\code{PipelineResult$new()}}
\item \href{#method-PipelineResult-run}{\code{PipelineResult$run()}}
\item \href{#method-PipelineResult-await}{\code{PipelineResult$await()}}
\item \href{#method-PipelineResult-print}{\code{PipelineResult$print()}}
\item \href{#method-PipelineResult-get_values}{\code{PipelineResult$get_values()}}
\item \href{#method-PipelineResult-clone}{\code{PipelineResult$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-validate"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-validate}{}}}
\subsection{Method \code{validate()}}{
check if result is valid, raises errors when invalidated
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$validate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-invalidate"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-invalidate}{}}}
\subsection{Method \code{invalidate()}}{
invalidate the pipeline result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$invalidate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-get_progress"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-get_progress}{}}}
\subsection{Method \code{get_progress()}}{
get pipeline progress
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$get_progress()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-new}{}}}
\subsection{Method \code{new()}}{
constructor (internal)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$new(path = character(0L), verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{pipeline path}

\item{\code{verbose}}{whether to print warnings}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-run"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-run}{}}}
\subsection{Method \code{run()}}{
run pipeline (internal)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$run(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  async = FALSE,
  process = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{expression to evaluate}

\item{\code{env}}{environment of \code{expr}}

\item{\code{quoted}}{whether \code{expr} has been quoted}

\item{\code{async}}{whether the process runs in other sessions}

\item{\code{process}}{the process object inherits \code{\link[callr]{process}},
will be inferred from \code{expr} if \code{process=NULL},
and will raise errors if cannot be found}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-await"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-await}{}}}
\subsection{Method \code{await()}}{
wait until some targets get finished
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$await(names = NULL, timeout = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{target names to wait, default is \code{NULL}, i.e. to
wait for all targets that have been scheduled}

\item{\code{timeout}}{maximum waiting time in seconds}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-print"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-get_values}{}}}
\subsection{Method \code{get_values()}}{
get results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$get_values(names = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{the target names to read}

\item{\code{...}}{passed to \code{\link{pipeline_read}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineResult-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineResult-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineResult$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
