% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_camera.R
\name{render_camera}
\alias{render_camera}
\title{Render Camera}
\usage{
render_camera(theta = 45, phi = 45, zoom = 1, fov = 0)
}
\arguments{
\item{theta}{Default `45`. Rotation angle.}

\item{phi}{Default `45`. Azimuth angle. Maximum `90`.}

\item{zoom}{Default `1`. Positive value indicating camera magnification.}

\item{fov}{Default `0`. Field of view of the camera. Maximum `180`.}
}
\description{
Changes the position and properties of the camera around the scene. Wrapper around \link[rgl]{rgl.viewpoint}.
}
\examples{
\dontrun{
montereybay \%>\%
 sphere_shade() \%>\%
 plot_3d(montereybay,zscale=50)
render_snapshot()
}

#Shift the camera over
\dontrun{
render_camera(theta = -45, phi = 45)
render_snapshot()
}

#Shift to an overhead view
\dontrun{
render_camera(theta = 0, phi = 90,zoom=0.7)
render_snapshot()
}

#Shift to an front view
\dontrun{
render_camera(theta = -90, phi = 30,zoom=0.5)
render_snapshot()
}

#Change the FOV
\dontrun{
render_camera(theta = -90, phi = 30,zoom=0.5,fov=130)
render_snapshot()
rgl::rgl.close()
}

#Here we render a series of frames to later stitch together into a movie.
\dontrun{
montereybay \%>\%
 sphere_shade() \%>\%
 plot_3d(montereybay,zscale=50)

phivec = 20 + 70 * 1/(1 + exp(seq(-5, 10, length.out = 180)))
phivecfull = c(phivec, rev(phivec))
thetavec = 270 + 90 * sin(seq(0,359,length.out = 360) * pi/180)
zoomvec = 0.5 + 0.5 * 1/(1 + exp(seq(-5, 10, length.out = 180)))
zoomvecfull = c(zoomvec, rev(zoomvec))

for(i in 1:360) {
 render_camera(theta = thetavec[i],phi = phivecfull[i],zoom = zoomvecfull[i])
 #uncomment the next line to save each frame to the working directory
 #render_snapshot(paste0("frame", i, ".png"))
}
#Run this command in the command line using ffmpeg to stitch together a video:
#ffmpeg -framerate 60 -i frame\%d.png -vcodec libx264 raymovie.mp4

#And run this command to convert the video to post to the web:
#ffmpeg -i raymovie.mp4 -pix_fmt yuv420p -profile:v baseline -level 3 -vf scale=-2:-2 rayweb.mp4
}
}
