% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_obj.R
\name{save_obj}
\alias{save_obj}
\title{Save OBJ}
\usage{
save_obj(
  filename,
  save_texture = TRUE,
  water_index_refraction = 1,
  manifold_geometry = FALSE,
  all_face_fields = FALSE
)
}
\arguments{
\item{filename}{String with the filename. If `.obj` is not at the end of the string, it will be appended automatically.}

\item{save_texture}{Default `TRUE`. If the texture should be saved along with the geometry.}

\item{water_index_refraction}{Default `1`. The index of refraction for the rendered water.}

\item{manifold_geometry}{Default `FALSE`. If `TRUE`, this will take the additional step of making the mesh manifold.}

\item{all_face_fields}{Default `FALSE`. If `TRUE`, all OBJ face fields (v/vn/vt) will always be written.}
}
\description{
Writes the textured 3D rayshader visualization to an OBJ file.
}
\examples{
filename_obj = tempfile(fileext = ".obj")

#Save model of volcano
\donttest{
volcano \%>\%
 sphere_shade() \%>\%
 plot_3d(volcano, zscale = 2)

save_obj(filename_obj)
}

#Save model of volcano without texture
\donttest{
save_obj(filename_obj, save_texture = FALSE)
rgl::rgl.close()
}

#Make water have realistic index of refraction
\donttest{
montereybay \%>\%
 sphere_shade() \%>\%
 plot_3d(montereybay, zscale = 50)
 
save_obj(filename_obj, water_index_refraction = 1.5)
rgl::rgl.close()
}
}
