#' raytracing: Rossby Wave Ray Tracing
#'
#' Rossby wave ray paths are traced from a determined source,
#' specified wavenumber, and direction of propagation.
#' 'raytracing' also works with a set of experiments changing
#' these parameters, making possible the identification of Rossby
#' wave sources automatically.
#'
#' @section Authors:
#' - Amanda Rehbein (ORCID: https://orcid.org/0000-0002-8714-7931 -
#'  mantainer: amanda.rehbein@usp.br)
#' - Tercio Ambrizzi (ORCID: https://orcid.org/0000-0001-8796-7326)
#' - Sergio Ibarra Espinosa (ORCID: https://orcid.org/0000-0002-3162-1905)
#' - Livia Marcia Mosso Dutra (ORCID: https://orcid.org/0000-0002-1349-7138)
#'
#' @references
#'
#' Hoskins, B. J., & Ambrizzi, T. (1993). Rossby wave propagation on
#' a realistic longitudinally varying flow. Journal of the Atmospheric
#' Sciences, 50(12), 1661-1671.
#'
#' Hoskins, B. J., & Karoly, D. J. (1981). The steady linear response
#' of a spherical atmosphere to thermal and orographic forcing. Journal
#' of the Atmospheric Sciences, 38(6), 1179-1196.
#'
#' Karoly, D. J. (1983). Rossby wave propagation in a barotropic atmosphere.
#' Dynamics of Atmospheres and Oceans, 7(2), 111-125.
#'
#' Yang, G. Y., & Hoskins, B. J. (1996). Propagation of Rossby waves of nonzero
#' frequency. Journal of the atmospheric sciences, 53(16), 2365-2378.
#'
#' @docType package
#' @name raytracing
NULL
#> NULL
