% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{cube_mesh}
\alias{cube_mesh}
\title{Cube 3D Model}
\usage{
cube_mesh(
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  material = material_list()
)
}
\arguments{
\item{position}{Default `c(0,0,0)`. Position of the mesh.}

\item{scale}{Default `c(1,1,1)`. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default `c(0,0,0)`. Angle to rotate the mesh.}

\item{pivot_point}{Default `c(0,0,0)`. Point around which to rotate the mesh.}

\item{order_rotation}{Default `c(1,2,3)`. Order to rotate the axes.}

\item{material}{Default `material_list()` (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
3D obj model of the letter R
}
\examples{
if(rayvertex:::run_documentation()) {
#Generate a cube
generate_cornell_mesh() |>
  add_shape(cube_mesh(position = c(555/2, 100, 555/2), scale = 100)) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
if(rayvertex:::run_documentation()) {
#Generate a blue rotated cube 
generate_cornell_mesh() |>
  add_shape(cube_mesh(position = c(555/2, 100, 555/2), scale = 100, angle=c(0,45,0),
                      material = material_list(diffuse="dodgerblue"))) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
if(rayvertex:::run_documentation()) {
#Generate a scaled, blue rotated cube 
generate_cornell_mesh() |>
  add_shape(cube_mesh(position = c(555/2, 100, 555/2), angle=c(0,45,0),
                      scale = c(2,0.5,0.8)*100,
                      material = material_list(diffuse="dodgerblue"))) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
}
